/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock;

import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.ChatCompletionInput;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.services.amazonbedrock.AmazonBedrockRequestManager;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.request.completion.AmazonBedrockChatCompletionEntityFactory;
import org.elasticsearch.xpack.inference.services.amazonbedrock.request.completion.AmazonBedrockChatCompletionRequest;
import org.elasticsearch.xpack.inference.services.amazonbedrock.request.completion.AmazonBedrockConverseRequestEntity;
import org.elasticsearch.xpack.inference.services.amazonbedrock.response.completion.AmazonBedrockChatCompletionResponseHandler;

public class AmazonBedrockChatCompletionRequestManager
extends AmazonBedrockRequestManager {
    private static final Logger logger = LogManager.getLogger(AmazonBedrockChatCompletionRequestManager.class);
    private final AmazonBedrockChatCompletionModel model;

    public AmazonBedrockChatCompletionRequestManager(AmazonBedrockChatCompletionModel model, ThreadPool threadPool, @Nullable TimeValue timeout) {
        super(model, threadPool, timeout);
        this.model = model;
    }

    @Override
    public void execute(InferenceInputs inferenceInputs, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> listener) {
        ChatCompletionInput chatCompletionInput = inferenceInputs.castTo(ChatCompletionInput.class);
        List<String> inputs = chatCompletionInput.getInputs();
        boolean stream = chatCompletionInput.stream();
        AmazonBedrockConverseRequestEntity requestEntity = AmazonBedrockChatCompletionEntityFactory.createEntity(this.model, inputs);
        AmazonBedrockChatCompletionRequest request = new AmazonBedrockChatCompletionRequest(this.model, requestEntity, this.timeout, stream);
        AmazonBedrockChatCompletionResponseHandler responseHandler = new AmazonBedrockChatCompletionResponseHandler();
        try {
            requestSender.send(logger, request, hasRequestCompletedFunction, responseHandler, listener);
        }
        catch (Exception e) {
            String errorMessage = Strings.format((String)"Failed to send [completion] request from inference entity id [%s]", (Object[])new Object[]{request.getInferenceEntityId()});
            logger.warn(errorMessage, (Throwable)e);
            listener.onFailure((Exception)new ElasticsearchException(errorMessage, (Throwable)e, new Object[0]));
        }
    }
}

