/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.alibabacloudsearch.response;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.inference.WeightedToken;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.inference.results.SparseEmbeddingResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.response.AlibabaCloudSearchResponseEntity;

public class AlibabaCloudSearchSparseResponseEntity
extends AlibabaCloudSearchResponseEntity {
    private static final String FAILED_TO_FIND_FIELD_TEMPLATE = "Failed to find required field [%s] in AlibabaCloud Search sparse embeddings response";

    public static SparseEmbeddingResults fromResponse(Request request, HttpResult response) throws IOException {
        return (SparseEmbeddingResults)AlibabaCloudSearchSparseResponseEntity.fromResponse(request, response, jsonParser -> {
            XContentUtils.positionParserAtTokenAfterField(jsonParser, "sparse_embeddings", FAILED_TO_FIND_FIELD_TEMPLATE);
            List embeddingList = XContentParserUtils.parseList((XContentParser)jsonParser, AlibabaCloudSearchSparseResponseEntity::parseEmbeddingObject);
            return new SparseEmbeddingResults(embeddingList);
        });
    }

    private static SparseEmbeddingResults.Embedding parseEmbeddingObject(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        XContentUtils.positionParserAtTokenAfterField(parser, "embedding", FAILED_TO_FIND_FIELD_TEMPLATE);
        List<WeightedToken> tokens = AlibabaCloudSearchSparseResponseEntity.parseWeightedTokenList(parser);
        parser.nextToken();
        parser.skipChildren();
        return new SparseEmbeddingResults.Embedding(tokens, false);
    }

    private static List<WeightedToken> parseWeightedTokenList(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        if (parser.nextToken() == XContentParser.Token.END_ARRAY) {
            return List.of();
        }
        ArrayList<WeightedToken> list = new ArrayList<WeightedToken>();
        do {
            WeightedToken token;
            if ((token = AlibabaCloudSearchSparseResponseEntity.parseEmbeddingList(parser)) == null) continue;
            list.add(token);
        } while (parser.nextToken() != XContentParser.Token.END_ARRAY);
        return list;
    }

    private static WeightedToken parseEmbeddingList(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        Map values = parser.map();
        Object tokenName = values.containsKey("token") ? values.get("token") : values.get("token_id");
        float weight = Float.parseFloat(values.get("weight").toString());
        if (AlibabaCloudSearchSparseResponseEntity.invalidToken(tokenName) || weight <= 0.0f) {
            return null;
        }
        return new WeightedToken(tokenName.toString(), weight);
    }

    private static boolean invalidToken(Object tokenName) {
        if (tokenName == null) {
            return true;
        }
        String token = tokenName.toString();
        return token.isEmpty() || token.contains(".");
    }

    private AlibabaCloudSearchSparseResponseEntity() {
    }
}

