/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.response.streaming;

import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEvent;

public class ServerSentEventParser {
    private static final String BOM = "\ufeff";
    private static final String TYPE_FIELD = "event";
    private static final String DATA_FIELD = "data";
    private final EventBuffer eventBuffer = new EventBuffer();
    private volatile String previousTokens = "";

    public Deque<ServerSentEvent> parse(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return new ArrayDeque<ServerSentEvent>(0);
        }
        String body = this.previousTokens + new String(bytes, StandardCharsets.UTF_8);
        Stream<String> lines = body.lines();
        ArrayDeque<ServerSentEvent> collector = new ArrayDeque<ServerSentEvent>();
        lines.reduce((previousLine, nextLine) -> {
            String line = previousLine.replace(BOM, "");
            if (line.isEmpty()) {
                this.eventBuffer.dispatch().ifPresent(collector::offer);
            } else if (!line.startsWith(":")) {
                if (line.contains(":")) {
                    this.fieldValueEvent(line);
                } else if (DATA_FIELD.equals(line.toLowerCase(Locale.ROOT))) {
                    this.eventBuffer.data("");
                }
            }
            return nextLine;
        }).ifPresent(lastLine -> {
            if (lastLine.isEmpty()) {
                this.eventBuffer.dispatch().ifPresent(collector::offer);
                this.previousTokens = "";
            } else {
                this.previousTokens = lastLine;
            }
        });
        return collector;
    }

    private void fieldValueEvent(String lineWithColon) {
        String trimmedValue;
        int firstColon = lineWithColon.indexOf(":");
        String fieldStr = lineWithColon.substring(0, firstColon).toLowerCase(Locale.ROOT);
        String value = lineWithColon.substring(firstColon + 1);
        String string = trimmedValue = value.length() > 0 && value.charAt(0) == ' ' ? value.substring(1) : value;
        if (DATA_FIELD.equals(fieldStr)) {
            this.eventBuffer.data(trimmedValue);
        } else if (TYPE_FIELD.equals(fieldStr)) {
            this.eventBuffer.type(trimmedValue);
        }
    }

    private static class EventBuffer {
        private static final char LINE_FEED = '\n';
        private static final String MESSAGE = "message";
        private StringBuilder type = new StringBuilder();
        private StringBuilder data = new StringBuilder();
        private boolean appendLineFeed = false;

        private EventBuffer() {
        }

        private void type(String type) {
            this.type.append(type);
        }

        private void data(String data) {
            if (this.appendLineFeed) {
                this.data.append('\n');
            } else {
                this.appendLineFeed = true;
            }
            this.data.append(data);
        }

        private Optional<ServerSentEvent> dispatch() {
            if (this.data.isEmpty()) {
                this.reset();
                return Optional.empty();
            }
            String dataValue = this.data.toString();
            String typeValue = this.type.toString();
            typeValue = typeValue.isBlank() ? MESSAGE : typeValue;
            this.reset();
            return Optional.of(new ServerSentEvent(typeValue, dataValue));
        }

        private void reset() {
            this.type = new StringBuilder();
            this.data = new StringBuilder();
            this.appendLineFeed = false;
        }
    }
}

