/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.request;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.rest.RestStatus;

public class RequestUtils {
    public static Header createAuthBearerHeader(SecureString apiKey) {
        return new BasicHeader("Authorization", "Bearer " + apiKey.toString());
    }

    public static URI buildUri(URI accountUri, String service, CheckedSupplier<URI, URISyntaxException> uriBuilder) {
        try {
            return accountUri == null ? (URI)uriBuilder.get() : accountUri;
        }
        catch (URISyntaxException e) {
            throw new ElasticsearchStatusException(Strings.format((String)"Failed to construct %s URL", (Object[])new Object[]{service}), RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]);
        }
    }

    public static URI buildUri(String service, CheckedSupplier<URI, URISyntaxException> uriBuilder) {
        return RequestUtils.buildUri(null, service, uriBuilder);
    }

    private RequestUtils() {
    }
}

