/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action;

import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SingleInputSenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.external.http.sender.RequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;

public sealed class SenderExecutableAction
implements ExecutableAction
permits SingleInputSenderExecutableAction {
    private final Sender sender;
    private final RequestManager requestManager;
    private final String failedToSendRequestErrorMessage;

    public SenderExecutableAction(Sender sender, RequestManager requestManager, String failedToSendRequestErrorMessage) {
        this.sender = Objects.requireNonNull(sender);
        this.requestManager = Objects.requireNonNull(requestManager);
        this.failedToSendRequestErrorMessage = Objects.requireNonNull(failedToSendRequestErrorMessage);
    }

    @Override
    public void execute(InferenceInputs inferenceInputs, TimeValue timeout, ActionListener<InferenceServiceResults> listener) {
        ActionListener<InferenceServiceResults> wrappedListener = ActionUtils.wrapFailuresInElasticsearchException(this.failedToSendRequestErrorMessage, listener);
        try {
            this.sender.send(this.requestManager, inferenceInputs, timeout, wrappedListener);
        }
        catch (Exception e) {
            wrappedListener.onFailure(e);
        }
    }
}

