/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.common;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.unit.ByteSizeValue;

public final class SizeLimitInputStream
extends FilterInputStream {
    private final long maxByteSize;
    private final AtomicLong byteCounter = new AtomicLong(0L);

    public SizeLimitInputStream(ByteSizeValue maxByteSize, InputStream in) {
        super(in);
        this.maxByteSize = maxByteSize.getBytes();
    }

    @Override
    public int read() throws IOException {
        int bytesRead = super.read();
        if (bytesRead != -1) {
            this.byteCounter.incrementAndGet();
            this.checkMaximumLengthReached();
        }
        return bytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = super.read(b, off, len);
        if (bytesRead != -1) {
            this.byteCounter.addAndGet(len);
            this.checkMaximumLengthReached();
        }
        return bytesRead;
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException("mark not supported");
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private void checkMaximumLengthReached() throws InputStreamTooLargeException {
        if (this.byteCounter.get() > this.maxByteSize) {
            throw new InputStreamTooLargeException("Maximum limit of [" + this.maxByteSize + "] bytes reached");
        }
    }

    public static class InputStreamTooLargeException
    extends IOException {
        public InputStreamTooLargeException(String message) {
            super(message);
        }
    }
}

