/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.inference.EmptySecretSettings;
import org.elasticsearch.inference.EmptyTaskSettings;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.xpack.core.inference.results.ChatCompletionResults;
import org.elasticsearch.xpack.core.inference.results.LegacyTextEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.RankedDocsResults;
import org.elasticsearch.xpack.core.inference.results.SparseEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.StreamingChatCompletionResults;
import org.elasticsearch.xpack.core.inference.results.StreamingUnifiedChatCompletionResults;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingByteResults;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingFloatResults;
import org.elasticsearch.xpack.inference.action.task.StreamingTaskManager;
import org.elasticsearch.xpack.inference.chunking.NoneChunkingSettings;
import org.elasticsearch.xpack.inference.chunking.RecursiveChunkingSettings;
import org.elasticsearch.xpack.inference.chunking.SentenceBoundaryChunkingSettings;
import org.elasticsearch.xpack.inference.chunking.WordBoundaryChunkingSettings;
import org.elasticsearch.xpack.inference.common.amazon.AwsSecretSettings;
import org.elasticsearch.xpack.inference.registry.ClearInferenceEndpointCacheAction;
import org.elasticsearch.xpack.inference.services.ai21.completion.Ai21ChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.AlibabaCloudSearchServiceSettings;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.completion.AlibabaCloudSearchCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.completion.AlibabaCloudSearchCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.embeddings.AlibabaCloudSearchEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.embeddings.AlibabaCloudSearchEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.rerank.AlibabaCloudSearchRerankServiceSettings;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.rerank.AlibabaCloudSearchRerankTaskSettings;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.sparse.AlibabaCloudSearchSparseServiceSettings;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.sparse.AlibabaCloudSearchSparseTaskSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.completion.AmazonBedrockChatCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.embeddings.AmazonBedrockEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.embeddings.AmazonBedrockEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.anthropic.completion.AnthropicChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.anthropic.completion.AnthropicChatCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.azureaistudio.completion.AzureAiStudioChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.azureaistudio.completion.AzureAiStudioChatCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.azureaistudio.embeddings.AzureAiStudioEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.azureaistudio.embeddings.AzureAiStudioEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.azureaistudio.rerank.AzureAiStudioRerankServiceSettings;
import org.elasticsearch.xpack.inference.services.azureaistudio.rerank.AzureAiStudioRerankTaskSettings;
import org.elasticsearch.xpack.inference.services.azureopenai.AzureOpenAiSecretSettings;
import org.elasticsearch.xpack.inference.services.azureopenai.completion.AzureOpenAiCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.azureopenai.completion.AzureOpenAiCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.azureopenai.embeddings.AzureOpenAiEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.azureopenai.embeddings.AzureOpenAiEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.cohere.CohereServiceSettings;
import org.elasticsearch.xpack.inference.services.cohere.completion.CohereCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.cohere.embeddings.CohereEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.cohere.embeddings.CohereEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.cohere.rerank.CohereRerankServiceSettings;
import org.elasticsearch.xpack.inference.services.cohere.rerank.CohereRerankTaskSettings;
import org.elasticsearch.xpack.inference.services.custom.CustomSecretSettings;
import org.elasticsearch.xpack.inference.services.custom.CustomServiceSettings;
import org.elasticsearch.xpack.inference.services.custom.CustomTaskSettings;
import org.elasticsearch.xpack.inference.services.custom.response.CompletionResponseParser;
import org.elasticsearch.xpack.inference.services.custom.response.CustomResponseParser;
import org.elasticsearch.xpack.inference.services.custom.response.NoopResponseParser;
import org.elasticsearch.xpack.inference.services.custom.response.RerankResponseParser;
import org.elasticsearch.xpack.inference.services.custom.response.SparseEmbeddingResponseParser;
import org.elasticsearch.xpack.inference.services.custom.response.TextEmbeddingResponseParser;
import org.elasticsearch.xpack.inference.services.deepseek.DeepSeekChatCompletionModel;
import org.elasticsearch.xpack.inference.services.elastic.completion.ElasticInferenceServiceCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.elastic.densetextembeddings.ElasticInferenceServiceDenseTextEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.elastic.rerank.ElasticInferenceServiceRerankServiceSettings;
import org.elasticsearch.xpack.inference.services.elastic.sparseembeddings.ElasticInferenceServiceSparseEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.CustomElandInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.CustomElandInternalTextEmbeddingServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticRerankerServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElserInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElserMlNodeTaskSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.MultilingualE5SmallInternalServiceSettings;
import org.elasticsearch.xpack.inference.services.elasticsearch.RerankTaskSettings;
import org.elasticsearch.xpack.inference.services.googleaistudio.completion.GoogleAiStudioCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.googleaistudio.embeddings.GoogleAiStudioEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiSecretSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.completion.GoogleVertexAiChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.completion.GoogleVertexAiChatCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.embeddings.GoogleVertexAiEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.embeddings.GoogleVertexAiEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.rerank.GoogleVertexAiRerankServiceSettings;
import org.elasticsearch.xpack.inference.services.googlevertexai.rerank.GoogleVertexAiRerankTaskSettings;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceServiceSettings;
import org.elasticsearch.xpack.inference.services.huggingface.completion.HuggingFaceChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.huggingface.elser.HuggingFaceElserServiceSettings;
import org.elasticsearch.xpack.inference.services.huggingface.rerank.HuggingFaceRerankServiceSettings;
import org.elasticsearch.xpack.inference.services.huggingface.rerank.HuggingFaceRerankTaskSettings;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.completion.IbmWatsonxChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.embeddings.IbmWatsonxEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.rerank.IbmWatsonxRerankServiceSettings;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.rerank.IbmWatsonxRerankTaskSettings;
import org.elasticsearch.xpack.inference.services.jinaai.JinaAIServiceSettings;
import org.elasticsearch.xpack.inference.services.jinaai.embeddings.JinaAIEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.jinaai.embeddings.JinaAIEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.jinaai.rerank.JinaAIRerankServiceSettings;
import org.elasticsearch.xpack.inference.services.jinaai.rerank.JinaAIRerankTaskSettings;
import org.elasticsearch.xpack.inference.services.llama.completion.LlamaChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.llama.embeddings.LlamaEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.mistral.completion.MistralChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.mistral.embeddings.MistralEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.openai.completion.OpenAiChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.openai.completion.OpenAiChatCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.openai.embeddings.OpenAiEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.openai.embeddings.OpenAiEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.sagemaker.model.SageMakerModel;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerSchemas;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;
import org.elasticsearch.xpack.inference.services.voyageai.VoyageAIServiceSettings;
import org.elasticsearch.xpack.inference.services.voyageai.embeddings.VoyageAIEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.voyageai.embeddings.VoyageAIEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.voyageai.rerank.VoyageAIRerankServiceSettings;
import org.elasticsearch.xpack.inference.services.voyageai.rerank.VoyageAIRerankTaskSettings;

public class InferenceNamedWriteablesProvider {
    private InferenceNamedWriteablesProvider() {
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> namedWriteables = new ArrayList<NamedWriteableRegistry.Entry>();
        namedWriteables.add(new NamedWriteableRegistry.Entry(InferenceResults.class, "text_embedding_results", LegacyTextEmbeddingResults::new));
        InferenceNamedWriteablesProvider.addInferenceResultsNamedWriteables(namedWriteables);
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "empty_task_settings", EmptyTaskSettings::new));
        InferenceNamedWriteablesProvider.addChunkingSettingsNamedWriteables(namedWriteables);
        namedWriteables.add(new NamedWriteableRegistry.Entry(SecretSettings.class, "empty_secret_settings", EmptySecretSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(SecretSettings.class, "default_secret_settings", DefaultSecretSettings::new));
        InferenceNamedWriteablesProvider.addInternalNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addHuggingFaceNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addOpenAiNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addCohereNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addAzureOpenAiNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addAzureAiStudioNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addGoogleAiStudioNamedWritables(namedWriteables);
        InferenceNamedWriteablesProvider.addIbmWatsonxNamedWritables(namedWriteables);
        InferenceNamedWriteablesProvider.addGoogleVertexAiNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addMistralNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addCustomElandWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addAnthropicNamedWritables(namedWriteables);
        InferenceNamedWriteablesProvider.addAmazonBedrockNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addAwsNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addElasticNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addAlibabaCloudSearchNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addJinaAINamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addVoyageAINamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addCustomNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addLlamaNamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addAi21NamedWriteables(namedWriteables);
        InferenceNamedWriteablesProvider.addUnifiedNamedWriteables(namedWriteables);
        namedWriteables.addAll(StreamingTaskManager.namedWriteables());
        namedWriteables.addAll(DeepSeekChatCompletionModel.namedWriteables());
        namedWriteables.addAll(SageMakerModel.namedWriteables());
        namedWriteables.addAll(SageMakerSchemas.namedWriteables());
        return namedWriteables;
    }

    private static void addCustomNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "custom_service_settings", CustomServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "custom_task_settings", CustomTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(SecretSettings.class, "custom_secret_settings", CustomSecretSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(CustomResponseParser.class, "text_embedding_response_parser", TextEmbeddingResponseParser::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(CustomResponseParser.class, "sparse_embedding_response_parser", SparseEmbeddingResponseParser::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(CustomResponseParser.class, "rerank_response_parser", RerankResponseParser::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(CustomResponseParser.class, "noop_response_parser", NoopResponseParser::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(CustomResponseParser.class, "completion_response_parser", CompletionResponseParser::new));
    }

    private static void addUnifiedNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        List writeables = UnifiedCompletionRequest.getNamedWriteables();
        namedWriteables.addAll(writeables);
    }

    private static void addAmazonBedrockNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "amazon_bedrock_embeddings_service_settings", AmazonBedrockEmbeddingsServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "amazon_bedrock_embeddings_task_settings", AmazonBedrockEmbeddingsTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "amazon_bedrock_chat_completion_service_settings", AmazonBedrockChatCompletionServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "amazon_bedrock_chat_completion_task_settings", AmazonBedrockChatCompletionTaskSettings::new));
    }

    private static void addAwsNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(AwsSecretSettings.class, "aws_secret_settings", AwsSecretSettings::new));
    }

    private static void addMistralNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "mistral_embeddings_service_settings", MistralEmbeddingsServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "mistral_completions_service_settings", MistralChatCompletionServiceSettings::new));
    }

    private static void addLlamaNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "llama_embeddings_service_settings", LlamaEmbeddingsServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "llama_completion_service_settings", LlamaChatCompletionServiceSettings::new));
    }

    private static void addAi21NamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "ai21_completions_service_settings", Ai21ChatCompletionServiceSettings::new));
    }

    private static void addAzureAiStudioNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "azure_ai_studio_embeddings_service_settings", AzureAiStudioEmbeddingsServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "azure_ai_studio_embeddings_task_settings", AzureAiStudioEmbeddingsTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "azure_ai_studio_chat_completion_service_settings", AzureAiStudioChatCompletionServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "azure_ai_studio_chat_completion_task_settings", AzureAiStudioChatCompletionTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "azure_ai_studio_rerank_service_settings", AzureAiStudioRerankServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "azure_ai_studio_rerank_task_settings", AzureAiStudioRerankTaskSettings::new));
    }

    private static void addAzureOpenAiNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(AzureOpenAiSecretSettings.class, "azure_openai_secret_settings", AzureOpenAiSecretSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "azure_openai_embeddings_service_settings", AzureOpenAiEmbeddingsServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "azure_openai_embeddings_task_settings", AzureOpenAiEmbeddingsTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "azure_openai_completions_service_settings", AzureOpenAiCompletionServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "azure_openai_completion_task_settings", AzureOpenAiCompletionTaskSettings::new));
    }

    private static void addCohereNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "cohere_service_settings", CohereServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "cohere_embeddings_service_settings", CohereEmbeddingsServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "cohere_embeddings_task_settings", CohereEmbeddingsTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "cohere_rerank_service_settings", CohereRerankServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "cohere_rerank_task_settings", CohereRerankTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "cohere_completion_service_settings", CohereCompletionServiceSettings::new));
    }

    private static void addOpenAiNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "openai_service_settings", OpenAiEmbeddingsServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "openai_embeddings_task_settings", OpenAiEmbeddingsTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "openai_completion_service_settings", OpenAiChatCompletionServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "openai_completion_task_settings", OpenAiChatCompletionTaskSettings::new));
    }

    private static void addHuggingFaceNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "hugging_face_elser_service_settings", HuggingFaceElserServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "hugging_face_service_settings", HuggingFaceServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "hugging_face_completion_service_settings", HuggingFaceChatCompletionServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "hugging_face_rerank_task_settings", HuggingFaceRerankTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "hugging_face_rerank_service_settings", HuggingFaceRerankServiceSettings::new));
    }

    private static void addGoogleAiStudioNamedWritables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "google_ai_studio_completion_service_settings", GoogleAiStudioCompletionServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "google_ai_studio_embeddings_service_settings", GoogleAiStudioEmbeddingsServiceSettings::new));
    }

    private static void addIbmWatsonxNamedWritables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "ibmwatsonx_embeddings_service_settings", IbmWatsonxEmbeddingsServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "ibm_watsonx_rerank_service_settings", IbmWatsonxRerankServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "ibm_watsonx_rerank_task_settings", IbmWatsonxRerankTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "ibm_watsonx_completion_service_settings", IbmWatsonxChatCompletionServiceSettings::new));
    }

    private static void addGoogleVertexAiNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(SecretSettings.class, "google_vertex_ai_secret_settings", GoogleVertexAiSecretSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "google_vertex_ai_embeddings_service_settings", GoogleVertexAiEmbeddingsServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "google_vertex_ai_embeddings_task_settings", GoogleVertexAiEmbeddingsTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "google_vertex_ai_rerank_service_settings", GoogleVertexAiRerankServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "google_vertex_ai_rerank_task_settings", GoogleVertexAiRerankTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "google_vertex_ai_chatcompletion_service_settings", GoogleVertexAiChatCompletionServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "google_vertex_ai_chatcompletion_task_settings", GoogleVertexAiChatCompletionTaskSettings::new));
    }

    private static void addInternalNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "elser_mlnode_service_settings", ElserInternalServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "elser_mlnode_task_settings", ElserMlNodeTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "text_embedding_internal_service_settings", ElasticsearchInternalServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "multilingual_e5_small_service_settings", MultilingualE5SmallInternalServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "elastic_reranker_service_settings", ElasticRerankerServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(Metadata.ProjectCustom.class, "inference-endpoint-cache-metadata", ClearInferenceEndpointCacheAction.InvalidateCacheMetadata::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(NamedDiff.class, "inference-endpoint-cache-metadata", in -> AbstractNamedDiffable.readDiffFrom(Metadata.ProjectCustom.class, (String)"inference-endpoint-cache-metadata", (StreamInput)in)));
    }

    private static void addChunkingSettingsNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ChunkingSettings.class, "NoneChunkingSettings", in -> NoneChunkingSettings.INSTANCE));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ChunkingSettings.class, "WordBoundaryChunkingSettings", WordBoundaryChunkingSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ChunkingSettings.class, "SentenceBoundaryChunkingSettings", SentenceBoundaryChunkingSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ChunkingSettings.class, "RecursiveChunkingSettings", RecursiveChunkingSettings::new));
    }

    private static void addInferenceResultsNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(InferenceServiceResults.class, "sparse_embedding_results", SparseEmbeddingResults::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(InferenceServiceResults.class, "text_embedding_service_results", TextEmbeddingFloatResults::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(InferenceServiceResults.class, "text_embedding_service_byte_results", TextEmbeddingByteResults::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(InferenceServiceResults.class, "chat_completion_service_results", ChatCompletionResults::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(InferenceServiceResults.class, "rerank_service_results", RankedDocsResults::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(StreamingChatCompletionResults.Results.class, "streaming_chat_completion_results", StreamingChatCompletionResults.Results::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(StreamingUnifiedChatCompletionResults.Results.class, StreamingUnifiedChatCompletionResults.Results.NAME, StreamingUnifiedChatCompletionResults.Results::new));
    }

    private static void addCustomElandWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "custom_eland_model_internal_service_settings", CustomElandInternalServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "custom_eland_model_internal_text_embedding_service_settings", CustomElandInternalTextEmbeddingServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "custom_eland_rerank_task_settings", RerankTaskSettings::new));
    }

    private static void addAnthropicNamedWritables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "anthropic_completion_service_settings", AnthropicChatCompletionServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "anthropic_completion_task_settings", AnthropicChatCompletionTaskSettings::new));
    }

    private static void addAlibabaCloudSearchNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "alibabacloud_search_service_settings", AlibabaCloudSearchServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "alibabacloud_search_embeddings_service_settings", AlibabaCloudSearchEmbeddingsServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "alibabacloud_search_embeddings_task_settings", AlibabaCloudSearchEmbeddingsTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "alibabacloud_search_sparse_embeddings_service_settings", AlibabaCloudSearchSparseServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "alibabacloud_search_sparse_embeddings_task_settings", AlibabaCloudSearchSparseTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "alibabacloud_search_rerank_service_settings", AlibabaCloudSearchRerankServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "alibabacloud_search_rerank_task_settings", AlibabaCloudSearchRerankTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "alibabacloud_search_completion_service_settings", AlibabaCloudSearchCompletionServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "alibabacloud_search_completion_task_settings", AlibabaCloudSearchCompletionTaskSettings::new));
    }

    private static void addJinaAINamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "jinaai_service_settings", JinaAIServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "jinaai_embeddings_service_settings", JinaAIEmbeddingsServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "jinaai_embeddings_task_settings", JinaAIEmbeddingsTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "jinaai_rerank_service_settings", JinaAIRerankServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "jinaai_rerank_task_settings", JinaAIRerankTaskSettings::new));
    }

    private static void addVoyageAINamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "voyageai_service_settings", VoyageAIServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "voyageai_embeddings_service_settings", VoyageAIEmbeddingsServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "voyageai_embeddings_task_settings", VoyageAIEmbeddingsTaskSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "voyageai_rerank_service_settings", VoyageAIRerankServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(TaskSettings.class, "voyageai_rerank_task_settings", VoyageAIRerankTaskSettings::new));
    }

    private static void addElasticNamedWriteables(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "elastic_inference_service_sparse_embeddings_service_settings", ElasticInferenceServiceSparseEmbeddingsServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "elastic_inference_service_completion_service_settings", ElasticInferenceServiceCompletionServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "elastic_rerank_service_settings", ElasticInferenceServiceRerankServiceSettings::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(ServiceSettings.class, "elastic_inference_service_dense_embeddings_service_settings", ElasticInferenceServiceDenseTextEmbeddingsServiceSettings::new));
    }
}

