/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.analysis;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.esql.plan.IndexPattern;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnresolvedRelation;

public class PreAnalyzer {
    public PreAnalysis preAnalyze(LogicalPlan plan) {
        if (plan.analyzed()) {
            return PreAnalysis.EMPTY;
        }
        return this.doPreAnalyze(plan);
    }

    protected PreAnalysis doPreAnalyze(LogicalPlan plan) {
        Holder indexMode = new Holder();
        Holder index = new Holder();
        ArrayList<IndexPattern> lookupIndices = new ArrayList<IndexPattern>();
        plan.forEachUp(UnresolvedRelation.class, p -> {
            if (p.indexMode() == IndexMode.LOOKUP) {
                lookupIndices.add(p.indexPattern());
            } else if (indexMode.get() == null || indexMode.get() == p.indexMode()) {
                indexMode.set((Object)p.indexMode());
                index.set((Object)p.indexPattern());
            } else {
                throw new IllegalStateException("index mode is already set");
            }
        });
        ArrayList<Enrich> unresolvedEnriches = new ArrayList<Enrich>();
        plan.forEachUp(Enrich.class, unresolvedEnriches::add);
        Holder supportsAggregateMetricDouble = new Holder((Object)false);
        Holder supportsDenseVector = new Holder((Object)false);
        Holder useAggregateMetricDoubleWhenNotSupported = new Holder((Object)false);
        Holder useDenseVectorWhenNotSupported = new Holder((Object)false);
        if (indexMode.get() == IndexMode.TIME_SERIES) {
            useAggregateMetricDoubleWhenNotSupported.set((Object)true);
        }
        plan.forEachDown(p -> p.forEachExpression(UnresolvedFunction.class, fn -> {
            if (fn.name().equalsIgnoreCase("knn") || fn.name().equalsIgnoreCase("to_dense_vector") || fn.name().equalsIgnoreCase("v_cosine") || fn.name().equalsIgnoreCase("v_hamming") || fn.name().equalsIgnoreCase("v_l1_norm") || fn.name().equalsIgnoreCase("v_l2_norm") || fn.name().equalsIgnoreCase("v_dot_product") || fn.name().equalsIgnoreCase("v_magnitude")) {
                useDenseVectorWhenNotSupported.set((Object)true);
            }
            if (fn.name().equalsIgnoreCase("to_aggregate_metric_double")) {
                useAggregateMetricDoubleWhenNotSupported.set((Object)true);
            }
        }));
        plan.forEachUp(LogicalPlan::setPreAnalyzed);
        return new PreAnalysis((IndexMode)indexMode.get(), (IndexPattern)index.get(), unresolvedEnriches, lookupIndices, (Boolean)useAggregateMetricDoubleWhenNotSupported.get(), (Boolean)useDenseVectorWhenNotSupported.get());
    }

    public record PreAnalysis(IndexMode indexMode, IndexPattern indexPattern, List<Enrich> enriches, List<IndexPattern> lookupIndices, boolean useAggregateMetricDoubleWhenNotSupported, boolean useDenseVectorWhenNotSupported) {
        public static final PreAnalysis EMPTY = new PreAnalysis(null, null, List.of(), List.of(), false, false);
    }
}

