/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.compute.Describable;
import org.elasticsearch.compute.aggregation.AggregatorMode;
import org.elasticsearch.compute.aggregation.GroupingAggregator;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.TimeSeriesGroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.HashAggregationOperator;
import org.elasticsearch.compute.operator.Operator;

public class TimeSeriesAggregationOperator
extends HashAggregationOperator {
    private final Rounding.Prepared timeBucket;

    public TimeSeriesAggregationOperator(Rounding.Prepared timeBucket, List<GroupingAggregator.Factory> aggregators, Supplier<BlockHash> blockHash, DriverContext driverContext) {
        super(aggregators, blockHash, driverContext);
        this.timeBucket = timeBucket;
    }

    @Override
    protected GroupingAggregatorEvaluationContext evaluationContext(Block[] keys) {
        if (keys.length < 2) {
            return super.evaluationContext(keys);
        }
        final LongBlock timestamps = keys[0].elementType() == ElementType.LONG ? (LongBlock)keys[0] : (LongBlock)keys[1];
        return new TimeSeriesGroupingAggregatorEvaluationContext(this.driverContext){

            @Override
            public long rangeStartInMillis(int groupId) {
                return timestamps.getLong(groupId);
            }

            @Override
            public long rangeEndInMillis(int groupId) {
                return TimeSeriesAggregationOperator.this.timeBucket.nextRoundingValue(timestamps.getLong(groupId));
            }
        };
    }

    public record Factory(Rounding.Prepared timeBucket, List<BlockHash.GroupSpec> groups, AggregatorMode aggregatorMode, List<GroupingAggregator.Factory> aggregators, int maxPageSize) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new TimeSeriesAggregationOperator(this.timeBucket, this.aggregators, () -> BlockHash.build(this.groups, driverContext.blockFactory(), this.maxPageSize, true), driverContext);
        }

        @Override
        public String describe() {
            return "TimeSeriesAggregationOperator[mode = <not-needed>, aggs = " + this.aggregators.stream().map(Describable::describe).collect(Collectors.joining(", ")) + "]";
        }
    }
}

