/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene.read;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.lucene.read.ComputeBlockLoaderFactory;
import org.elasticsearch.compute.lucene.read.ValuesReader;
import org.elasticsearch.compute.lucene.read.ValuesReaderDocs;
import org.elasticsearch.compute.lucene.read.ValuesSourceReaderOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockLoaderStoredFieldsFromLeafLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.fetch.StoredFieldsSpec;

class ValuesFromSingleReader
extends ValuesReader {
    private static final Logger log = LogManager.getLogger(ValuesFromSingleReader.class);
    static final int SEQUENTIAL_BOUNDARY = 10;
    private final int shard;
    private final int segment;

    ValuesFromSingleReader(ValuesSourceReaderOperator operator, DocVector docs) {
        super(operator, docs);
        this.shard = docs.shards().getInt(0);
        this.segment = docs.segments().getInt(0);
        log.debug("initialized {} positions", new Object[]{docs.getPositionCount()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load(Block[] target, int offset) throws IOException {
        if (this.docs.singleSegmentNonDecreasing()) {
            this.loadFromSingleLeaf(this.operator.jumboBytes, target, new ValuesReaderDocs(this.docs), offset);
            return;
        }
        if (offset != 0) {
            throw new IllegalStateException("can only load partial pages with single-segment non-decreasing pages");
        }
        int[] forwards = this.docs.shardSegmentDocMapForwards();
        Releasable[] unshuffled = new Block[target.length];
        try {
            this.loadFromSingleLeaf(Long.MAX_VALUE, (Block[])unshuffled, new ValuesReaderDocs(this.docs).mapped(forwards), 0);
            int[] backwards = this.docs.shardSegmentDocMapBackwards();
            for (int i = 0; i < unshuffled.length; ++i) {
                target[i] = unshuffled[i].filter(backwards);
                unshuffled[i].close();
                unshuffled[i] = null;
            }
        }
        finally {
            Releasables.closeExpectNoException((Releasable[])unshuffled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromSingleLeaf(long jumboBytes, Block[] target, ValuesReaderDocs docs, int offset) throws IOException {
        int firstDoc = docs.get(offset);
        this.operator.positionFieldWork(this.shard, this.segment, firstDoc);
        StoredFieldsSpec storedFieldsSpec = StoredFieldsSpec.NO_REQUIREMENTS;
        LeafReaderContext ctx = this.operator.ctx(this.shard, this.segment);
        ArrayList<ColumnAtATimeWork> columnAtATimeReaders = new ArrayList<ColumnAtATimeWork>(this.operator.fields.length);
        ArrayList<RowStrideReaderWork> rowStrideReaders = new ArrayList<RowStrideReaderWork>(this.operator.fields.length);
        try (ComputeBlockLoaderFactory loaderBlockFactory = new ComputeBlockLoaderFactory(this.operator.blockFactory);){
            for (int f = 0; f < this.operator.fields.length; ++f) {
                ValuesSourceReaderOperator.FieldWork field = this.operator.fields[f];
                BlockLoader.ColumnAtATimeReader columnAtATime = field.columnAtATime(ctx);
                if (columnAtATime != null) {
                    columnAtATimeReaders.add(new ColumnAtATimeWork(columnAtATime, f));
                    continue;
                }
                rowStrideReaders.add(new RowStrideReaderWork(field.rowStride(ctx), (Block.Builder)field.loader.builder((BlockLoader.BlockFactory)loaderBlockFactory, docs.count() - offset), field.loader, f));
                storedFieldsSpec = storedFieldsSpec.merge(field.loader.rowStrideStoredFieldSpec());
            }
            if (!rowStrideReaders.isEmpty()) {
                this.loadFromRowStrideReaders(jumboBytes, target, storedFieldsSpec, rowStrideReaders, ctx, docs, offset);
            }
            for (ColumnAtATimeWork r : columnAtATimeReaders) {
                target[r.idx] = (Block)r.reader.read((BlockLoader.BlockFactory)loaderBlockFactory, (BlockLoader.Docs)docs, offset, this.operator.fields[r.idx].info.nullsFiltered());
                this.operator.sanityCheckBlock(r.reader, docs.count() - offset, target[r.idx], r.idx);
            }
            if (log.isDebugEnabled()) {
                long total = 0L;
                for (Block b : target) {
                    total += b.ramBytesUsed();
                }
                log.debug("loaded {} positions total ({} bytes)", new Object[]{target[0].getPositionCount(), total});
            }
        }
        finally {
            Releasables.close(rowStrideReaders);
        }
    }

    private void loadFromRowStrideReaders(long jumboBytes, Block[] target, StoredFieldsSpec storedFieldsSpec, List<RowStrideReaderWork> rowStrideReaders, LeafReaderContext ctx, ValuesReaderDocs docs, int offset) throws IOException {
        StoredFieldLoader storedFieldLoader;
        SourceLoader sourceLoader = null;
        ValuesSourceReaderOperator.ShardContext shardContext = this.operator.shardContexts.get(this.shard);
        if (storedFieldsSpec.requiresSource()) {
            sourceLoader = shardContext.newSourceLoader().get();
            storedFieldsSpec = storedFieldsSpec.merge(new StoredFieldsSpec(true, false, sourceLoader.requiredStoredFields()));
        }
        if (storedFieldsSpec.equals((Object)StoredFieldsSpec.NO_REQUIREMENTS)) {
            throw new IllegalStateException("found row stride readers [" + String.valueOf(rowStrideReaders) + "] without stored fields [" + String.valueOf(storedFieldsSpec) + "]");
        }
        if (this.useSequentialStoredFieldsReader(docs, shardContext.storedFieldsSequentialProportion())) {
            storedFieldLoader = StoredFieldLoader.fromSpecSequential((StoredFieldsSpec)storedFieldsSpec);
            this.operator.trackStoredFields(storedFieldsSpec, true);
        } else {
            storedFieldLoader = StoredFieldLoader.fromSpec((StoredFieldsSpec)storedFieldsSpec);
            this.operator.trackStoredFields(storedFieldsSpec, false);
        }
        BlockLoaderStoredFieldsFromLeafLoader storedFields = new BlockLoaderStoredFieldsFromLeafLoader(storedFieldLoader.getLoader(ctx, null), sourceLoader != null ? sourceLoader.leaf(ctx.reader(), null) : null);
        int p = offset;
        long estimated = 0L;
        while (p < docs.count() && estimated < jumboBytes) {
            int doc = docs.get(p++);
            storedFields.advanceTo(doc);
            for (RowStrideReaderWork work : rowStrideReaders) {
                work.read(doc, storedFields);
            }
            estimated = this.estimatedRamBytesUsed(rowStrideReaders);
            log.trace("{}: bytes loaded {}/{}", new Object[]{p, estimated, jumboBytes});
        }
        for (RowStrideReaderWork work : rowStrideReaders) {
            target[work.idx] = work.build();
            this.operator.sanityCheckBlock(work.reader, p - offset, target[work.idx], work.idx);
        }
        if (log.isDebugEnabled()) {
            long actual = 0L;
            for (RowStrideReaderWork work : rowStrideReaders) {
                actual += target[work.idx].ramBytesUsed();
            }
            log.debug("loaded {} positions row stride estimated/actual {}/{} bytes", new Object[]{p - offset, estimated, actual});
        }
        docs.setCount(p);
    }

    private boolean useSequentialStoredFieldsReader(BlockLoader.Docs docs, double storedFieldsSequentialProportion) {
        int count = docs.count();
        if (count < 10) {
            return false;
        }
        int range = docs.get(count - 1) - docs.get(0);
        return (double)range * storedFieldsSequentialProportion <= (double)count;
    }

    private long estimatedRamBytesUsed(List<RowStrideReaderWork> rowStrideReaders) {
        long estimated = 0L;
        for (RowStrideReaderWork r : rowStrideReaders) {
            estimated += r.builder.estimatedBytes();
        }
        return estimated;
    }

    private record ColumnAtATimeWork(BlockLoader.ColumnAtATimeReader reader, int idx) {
    }

    private record RowStrideReaderWork(BlockLoader.RowStrideReader reader, Block.Builder builder, BlockLoader loader, int idx) implements Releasable
    {
        void read(int doc, BlockLoaderStoredFieldsFromLeafLoader storedFields) throws IOException {
            this.reader.read(doc, (BlockLoader.StoredFields)storedFields, (BlockLoader.Builder)this.builder);
        }

        Block build() {
            return (Block)this.loader.convert((BlockLoader.Block)this.builder.build());
        }

        public void close() {
            this.builder.close();
        }
    }
}

