/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.util.List;
import org.elasticsearch.compute.lucene.ShardContext;
import org.elasticsearch.core.RefCounted;

public interface ShardRefCounted {
    public static final ShardRefCounted ALWAYS_REFERENCED = shardId -> RefCounted.ALWAYS_REFERENCED;

    public RefCounted get(int var1);

    public static ShardRefCounted fromList(List<? extends RefCounted> refCounters) {
        return shardId -> (RefCounted)refCounters.get(shardId);
    }

    public static ShardRefCounted fromShardContext(ShardContext shardContext) {
        return new Single(shardContext.index(), shardContext);
    }

    public record Single(int index, RefCounted refCounted) implements ShardRefCounted
    {
        @Override
        public RefCounted get(int shardId) {
            if (shardId != this.index) {
                throw new IllegalArgumentException("Invalid shardId: " + shardId + ", expected: " + this.index);
            }
            return this.refCounted;
        }
    }
}

