/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentGeoShapeSourceValuesAggregator;
import org.elasticsearch.compute.aggregation.spatial.SpatialExtentGroupingStateWrappedLongitudeState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SpatialExtentGeoShapeSourceValuesGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("top", ElementType.INT), new IntermediateStateDesc("bottom", ElementType.INT), new IntermediateStateDesc("negLeft", ElementType.INT), new IntermediateStateDesc("negRight", ElementType.INT), new IntermediateStateDesc("posLeft", ElementType.INT), new IntermediateStateDesc("posRight", ElementType.INT));
    private final SpatialExtentGroupingStateWrappedLongitudeState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;

    public SpatialExtentGeoShapeSourceValuesGroupingAggregatorFunction(List<Integer> channels, SpatialExtentGroupingStateWrappedLongitudeState state, DriverContext driverContext) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
    }

    public static SpatialExtentGeoShapeSourceValuesGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext) {
        return new SpatialExtentGeoShapeSourceValuesGroupingAggregatorFunction(channels, SpatialExtentGeoShapeSourceValuesAggregator.initGrouping(), driverContext);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final BytesRefBlock bytesBlock = (BytesRefBlock)page.getBlock(this.channels.get(0));
        final BytesRefVector bytesVector = bytesBlock.asVector();
        if (bytesVector == null) {
            this.maybeEnableGroupIdTracking(seenGroupIds, bytesBlock);
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                    SpatialExtentGeoShapeSourceValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, bytesBlock);
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                    SpatialExtentGeoShapeSourceValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, bytesBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    SpatialExtentGeoShapeSourceValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, bytesBlock);
                }

                public void close() {
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                SpatialExtentGeoShapeSourceValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, bytesVector);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                SpatialExtentGeoShapeSourceValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, bytesVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                SpatialExtentGeoShapeSourceValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, bytesVector);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, BytesRefBlock bytesBlock) {
        BytesRef bytesScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || bytesBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int bytesStart = bytesBlock.getFirstValueIndex(valuesPosition);
                int bytesEnd = bytesStart + bytesBlock.getValueCount(valuesPosition);
                for (int bytesOffset = bytesStart; bytesOffset < bytesEnd; ++bytesOffset) {
                    BytesRef bytesValue = bytesBlock.getBytesRef(bytesOffset, bytesScratch);
                    SpatialExtentGeoShapeSourceValuesAggregator.combine(this.state, groupId, bytesValue);
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, BytesRefVector bytesVector) {
        BytesRef bytesScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                BytesRef bytesValue = bytesVector.getBytesRef(valuesPosition, bytesScratch);
                SpatialExtentGeoShapeSourceValuesAggregator.combine(this.state, groupId, bytesValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object topUncast = page.getBlock(this.channels.get(0));
        if (topUncast.areAllValuesNull()) {
            return;
        }
        IntVector top = ((IntBlock)topUncast).asVector();
        Object bottomUncast = page.getBlock(this.channels.get(1));
        if (bottomUncast.areAllValuesNull()) {
            return;
        }
        IntVector bottom = ((IntBlock)bottomUncast).asVector();
        Object negLeftUncast = page.getBlock(this.channels.get(2));
        if (negLeftUncast.areAllValuesNull()) {
            return;
        }
        IntVector negLeft = ((IntBlock)negLeftUncast).asVector();
        Object negRightUncast = page.getBlock(this.channels.get(3));
        if (negRightUncast.areAllValuesNull()) {
            return;
        }
        IntVector negRight = ((IntBlock)negRightUncast).asVector();
        Object posLeftUncast = page.getBlock(this.channels.get(4));
        if (posLeftUncast.areAllValuesNull()) {
            return;
        }
        IntVector posLeft = ((IntBlock)posLeftUncast).asVector();
        Object posRightUncast = page.getBlock(this.channels.get(5));
        if (posRightUncast.areAllValuesNull()) {
            return;
        }
        IntVector posRight = ((IntBlock)posRightUncast).asVector();
        assert (top.getPositionCount() == bottom.getPositionCount() && top.getPositionCount() == negLeft.getPositionCount() && top.getPositionCount() == negRight.getPositionCount() && top.getPositionCount() == posLeft.getPositionCount() && top.getPositionCount() == posRight.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                SpatialExtentGeoShapeSourceValuesAggregator.combineIntermediate(this.state, groupId, top.getInt(valuesPosition), bottom.getInt(valuesPosition), negLeft.getInt(valuesPosition), negRight.getInt(valuesPosition), posLeft.getInt(valuesPosition), posRight.getInt(valuesPosition));
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, BytesRefBlock bytesBlock) {
        BytesRef bytesScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || bytesBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int bytesStart = bytesBlock.getFirstValueIndex(valuesPosition);
                int bytesEnd = bytesStart + bytesBlock.getValueCount(valuesPosition);
                for (int bytesOffset = bytesStart; bytesOffset < bytesEnd; ++bytesOffset) {
                    BytesRef bytesValue = bytesBlock.getBytesRef(bytesOffset, bytesScratch);
                    SpatialExtentGeoShapeSourceValuesAggregator.combine(this.state, groupId, bytesValue);
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, BytesRefVector bytesVector) {
        BytesRef bytesScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                BytesRef bytesValue = bytesVector.getBytesRef(valuesPosition, bytesScratch);
                SpatialExtentGeoShapeSourceValuesAggregator.combine(this.state, groupId, bytesValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object topUncast = page.getBlock(this.channels.get(0));
        if (topUncast.areAllValuesNull()) {
            return;
        }
        IntVector top = ((IntBlock)topUncast).asVector();
        Object bottomUncast = page.getBlock(this.channels.get(1));
        if (bottomUncast.areAllValuesNull()) {
            return;
        }
        IntVector bottom = ((IntBlock)bottomUncast).asVector();
        Object negLeftUncast = page.getBlock(this.channels.get(2));
        if (negLeftUncast.areAllValuesNull()) {
            return;
        }
        IntVector negLeft = ((IntBlock)negLeftUncast).asVector();
        Object negRightUncast = page.getBlock(this.channels.get(3));
        if (negRightUncast.areAllValuesNull()) {
            return;
        }
        IntVector negRight = ((IntBlock)negRightUncast).asVector();
        Object posLeftUncast = page.getBlock(this.channels.get(4));
        if (posLeftUncast.areAllValuesNull()) {
            return;
        }
        IntVector posLeft = ((IntBlock)posLeftUncast).asVector();
        Object posRightUncast = page.getBlock(this.channels.get(5));
        if (posRightUncast.areAllValuesNull()) {
            return;
        }
        IntVector posRight = ((IntBlock)posRightUncast).asVector();
        assert (top.getPositionCount() == bottom.getPositionCount() && top.getPositionCount() == negLeft.getPositionCount() && top.getPositionCount() == negRight.getPositionCount() && top.getPositionCount() == posLeft.getPositionCount() && top.getPositionCount() == posRight.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                SpatialExtentGeoShapeSourceValuesAggregator.combineIntermediate(this.state, groupId, top.getInt(valuesPosition), bottom.getInt(valuesPosition), negLeft.getInt(valuesPosition), negRight.getInt(valuesPosition), posLeft.getInt(valuesPosition), posRight.getInt(valuesPosition));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, BytesRefBlock bytesBlock) {
        BytesRef bytesScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            if (bytesBlock.isNull(valuesPosition)) continue;
            int groupId = groups.getInt(groupPosition);
            int bytesStart = bytesBlock.getFirstValueIndex(valuesPosition);
            int bytesEnd = bytesStart + bytesBlock.getValueCount(valuesPosition);
            for (int bytesOffset = bytesStart; bytesOffset < bytesEnd; ++bytesOffset) {
                BytesRef bytesValue = bytesBlock.getBytesRef(bytesOffset, bytesScratch);
                SpatialExtentGeoShapeSourceValuesAggregator.combine(this.state, groupId, bytesValue);
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, BytesRefVector bytesVector) {
        BytesRef bytesScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            int groupId = groups.getInt(groupPosition);
            BytesRef bytesValue = bytesVector.getBytesRef(valuesPosition, bytesScratch);
            SpatialExtentGeoShapeSourceValuesAggregator.combine(this.state, groupId, bytesValue);
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object topUncast = page.getBlock(this.channels.get(0));
        if (topUncast.areAllValuesNull()) {
            return;
        }
        IntVector top = ((IntBlock)topUncast).asVector();
        Object bottomUncast = page.getBlock(this.channels.get(1));
        if (bottomUncast.areAllValuesNull()) {
            return;
        }
        IntVector bottom = ((IntBlock)bottomUncast).asVector();
        Object negLeftUncast = page.getBlock(this.channels.get(2));
        if (negLeftUncast.areAllValuesNull()) {
            return;
        }
        IntVector negLeft = ((IntBlock)negLeftUncast).asVector();
        Object negRightUncast = page.getBlock(this.channels.get(3));
        if (negRightUncast.areAllValuesNull()) {
            return;
        }
        IntVector negRight = ((IntBlock)negRightUncast).asVector();
        Object posLeftUncast = page.getBlock(this.channels.get(4));
        if (posLeftUncast.areAllValuesNull()) {
            return;
        }
        IntVector posLeft = ((IntBlock)posLeftUncast).asVector();
        Object posRightUncast = page.getBlock(this.channels.get(5));
        if (posRightUncast.areAllValuesNull()) {
            return;
        }
        IntVector posRight = ((IntBlock)posRightUncast).asVector();
        assert (top.getPositionCount() == bottom.getPositionCount() && top.getPositionCount() == negLeft.getPositionCount() && top.getPositionCount() == negRight.getPositionCount() && top.getPositionCount() == posLeft.getPositionCount() && top.getPositionCount() == posRight.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            int valuesPosition = groupPosition + positionOffset;
            SpatialExtentGeoShapeSourceValuesAggregator.combineIntermediate(this.state, groupId, top.getInt(valuesPosition), bottom.getInt(valuesPosition), negLeft.getInt(valuesPosition), negRight.getInt(valuesPosition), posLeft.getInt(valuesPosition), posRight.getInt(valuesPosition));
        }
    }

    private void maybeEnableGroupIdTracking(SeenGroupIds seenGroupIds, BytesRefBlock bytesBlock) {
        if (bytesBlock.mayHaveNulls()) {
            this.state.enableGroupIdTracking(seenGroupIds);
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        blocks[offset] = SpatialExtentGeoShapeSourceValuesAggregator.evaluateFinal(this.state, selected, ctx);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

