/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopIntAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopIntGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopIntAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;
    private final boolean ascending;

    public TopIntAggregatorFunctionSupplier(int limit, boolean ascending) {
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return TopIntAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return TopIntGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public TopIntAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return TopIntAggregatorFunction.create(driverContext, channels, this.limit, this.ascending);
    }

    @Override
    public TopIntGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return TopIntGroupingAggregatorFunction.create(channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top of ints";
    }
}

