/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.TopBooleanAggregatorFunction;
import org.elasticsearch.compute.aggregation.TopBooleanGroupingAggregatorFunction;
import org.elasticsearch.compute.operator.DriverContext;

public final class TopBooleanAggregatorFunctionSupplier
implements AggregatorFunctionSupplier {
    private final int limit;
    private final boolean ascending;

    public TopBooleanAggregatorFunctionSupplier(int limit, boolean ascending) {
        this.limit = limit;
        this.ascending = ascending;
    }

    @Override
    public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
        return TopBooleanAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
        return TopBooleanGroupingAggregatorFunction.intermediateStateDesc();
    }

    @Override
    public TopBooleanAggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
        return TopBooleanAggregatorFunction.create(driverContext, channels, this.limit, this.ascending);
    }

    @Override
    public TopBooleanGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
        return TopBooleanGroupingAggregatorFunction.create(channels, driverContext, this.limit, this.ascending);
    }

    @Override
    public String describe() {
        return "top of booleans";
    }
}

