/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.LastDoubleByTimestampAggregator;
import org.elasticsearch.compute.aggregation.LongDoubleState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class LastDoubleByTimestampAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("timestamps", ElementType.LONG), new IntermediateStateDesc("values", ElementType.DOUBLE), new IntermediateStateDesc("seen", ElementType.BOOLEAN));
    private final DriverContext driverContext;
    private final LongDoubleState state;
    private final List<Integer> channels;

    public LastDoubleByTimestampAggregatorFunction(DriverContext driverContext, List<Integer> channels, LongDoubleState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static LastDoubleByTimestampAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new LastDoubleByTimestampAggregatorFunction(driverContext, channels, LastDoubleByTimestampAggregator.initSingle(driverContext));
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        DoubleBlock valueBlock = (DoubleBlock)page.getBlock(this.channels.get(0));
        LongBlock timestampBlock = (LongBlock)page.getBlock(this.channels.get(1));
        DoubleVector valueVector = valueBlock.asVector();
        if (valueVector == null) {
            this.addRawBlock(valueBlock, timestampBlock, mask);
            return;
        }
        LongVector timestampVector = timestampBlock.asVector();
        if (timestampVector == null) {
            this.addRawBlock(valueBlock, timestampBlock, mask);
            return;
        }
        this.addRawVector(valueVector, timestampVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        DoubleBlock valueBlock = (DoubleBlock)page.getBlock(this.channels.get(0));
        LongBlock timestampBlock = (LongBlock)page.getBlock(this.channels.get(1));
        DoubleVector valueVector = valueBlock.asVector();
        if (valueVector == null) {
            this.addRawBlock(valueBlock, timestampBlock);
            return;
        }
        LongVector timestampVector = timestampBlock.asVector();
        if (timestampVector == null) {
            this.addRawBlock(valueBlock, timestampBlock);
            return;
        }
        this.addRawVector(valueVector, timestampVector);
    }

    private void addRawVector(DoubleVector valueVector, LongVector timestampVector) {
        long timestampValue;
        double valueValue;
        int valuesPosition = 0;
        if (!this.state.seen() && valuesPosition < valueVector.getPositionCount()) {
            valueValue = valueVector.getDouble(valuesPosition);
            timestampValue = timestampVector.getLong(valuesPosition);
            LastDoubleByTimestampAggregator.first(this.state, valueValue, timestampValue);
            ++valuesPosition;
            this.state.seen(true);
        }
        while (valuesPosition < valueVector.getPositionCount()) {
            valueValue = valueVector.getDouble(valuesPosition);
            timestampValue = timestampVector.getLong(valuesPosition);
            LastDoubleByTimestampAggregator.combine(this.state, valueValue, timestampValue);
            ++valuesPosition;
        }
    }

    private void addRawVector(DoubleVector valueVector, LongVector timestampVector, BooleanVector mask) {
        long timestampValue;
        double valueValue;
        int valuesPosition;
        for (valuesPosition = 0; !this.state.seen() && valuesPosition < valueVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) {
                continue;
            }
            valueValue = valueVector.getDouble(valuesPosition);
            timestampValue = timestampVector.getLong(valuesPosition);
            LastDoubleByTimestampAggregator.first(this.state, valueValue, timestampValue);
            ++valuesPosition;
            this.state.seen(true);
            break;
        }
        while (valuesPosition < valueVector.getPositionCount()) {
            if (!mask.getBoolean(valuesPosition)) {
                ++valuesPosition;
                continue;
            }
            valueValue = valueVector.getDouble(valuesPosition);
            timestampValue = timestampVector.getLong(valuesPosition);
            LastDoubleByTimestampAggregator.combine(this.state, valueValue, timestampValue);
            ++valuesPosition;
        }
    }

    private void addRawBlock(DoubleBlock valueBlock, LongBlock timestampBlock) {
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            if (valueBlock.isNull(p) || timestampBlock.isNull(p)) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueBlock.getValueCount(p);
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                double valueValue = valueBlock.getDouble(valueOffset);
                int timestampStart = timestampBlock.getFirstValueIndex(p);
                int timestampEnd = timestampStart + timestampBlock.getValueCount(p);
                for (int timestampOffset = timestampStart; timestampOffset < timestampEnd; ++timestampOffset) {
                    long timestampValue = timestampBlock.getLong(timestampOffset);
                    if (this.state.seen()) {
                        LastDoubleByTimestampAggregator.combine(this.state, valueValue, timestampValue);
                        continue;
                    }
                    this.state.seen(true);
                    LastDoubleByTimestampAggregator.first(this.state, valueValue, timestampValue);
                }
            }
        }
    }

    private void addRawBlock(DoubleBlock valueBlock, LongBlock timestampBlock, BooleanVector mask) {
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            if (!mask.getBoolean(p) || valueBlock.isNull(p) || timestampBlock.isNull(p)) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueBlock.getValueCount(p);
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                double valueValue = valueBlock.getDouble(valueOffset);
                int timestampStart = timestampBlock.getFirstValueIndex(p);
                int timestampEnd = timestampStart + timestampBlock.getValueCount(p);
                for (int timestampOffset = timestampStart; timestampOffset < timestampEnd; ++timestampOffset) {
                    long timestampValue = timestampBlock.getLong(timestampOffset);
                    if (this.state.seen()) {
                        LastDoubleByTimestampAggregator.combine(this.state, valueValue, timestampValue);
                        continue;
                    }
                    this.state.seen(true);
                    LastDoubleByTimestampAggregator.first(this.state, valueValue, timestampValue);
                }
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + LastDoubleByTimestampAggregatorFunction.intermediateStateDesc().size());
        Object timestampsUncast = page.getBlock(this.channels.get(0));
        if (timestampsUncast.areAllValuesNull()) {
            return;
        }
        LongVector timestamps = ((LongBlock)timestampsUncast).asVector();
        assert (timestamps.getPositionCount() == 1);
        Object valuesUncast = page.getBlock(this.channels.get(1));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector values = ((DoubleBlock)valuesUncast).asVector();
        assert (values.getPositionCount() == 1);
        Object seenUncast = page.getBlock(this.channels.get(2));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (seen.getPositionCount() == 1);
        LastDoubleByTimestampAggregator.combineIntermediate(this.state, timestamps.getLong(0), values.getDouble(0), seen.getBoolean(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        if (!this.state.seen()) {
            blocks[offset] = driverContext.blockFactory().newConstantNullBlock(1);
            return;
        }
        blocks[offset] = LastDoubleByTimestampAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

