/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.FirstLongByTimestampAggregator;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.LongLongState;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class FirstLongByTimestampAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("timestamps", ElementType.LONG), new IntermediateStateDesc("values", ElementType.LONG), new IntermediateStateDesc("seen", ElementType.BOOLEAN));
    private final DriverContext driverContext;
    private final LongLongState state;
    private final List<Integer> channels;

    public FirstLongByTimestampAggregatorFunction(DriverContext driverContext, List<Integer> channels, LongLongState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static FirstLongByTimestampAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new FirstLongByTimestampAggregatorFunction(driverContext, channels, FirstLongByTimestampAggregator.initSingle(driverContext));
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        LongBlock valueBlock = (LongBlock)page.getBlock(this.channels.get(0));
        LongBlock timestampBlock = (LongBlock)page.getBlock(this.channels.get(1));
        LongVector valueVector = valueBlock.asVector();
        if (valueVector == null) {
            this.addRawBlock(valueBlock, timestampBlock, mask);
            return;
        }
        LongVector timestampVector = timestampBlock.asVector();
        if (timestampVector == null) {
            this.addRawBlock(valueBlock, timestampBlock, mask);
            return;
        }
        this.addRawVector(valueVector, timestampVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        LongBlock valueBlock = (LongBlock)page.getBlock(this.channels.get(0));
        LongBlock timestampBlock = (LongBlock)page.getBlock(this.channels.get(1));
        LongVector valueVector = valueBlock.asVector();
        if (valueVector == null) {
            this.addRawBlock(valueBlock, timestampBlock);
            return;
        }
        LongVector timestampVector = timestampBlock.asVector();
        if (timestampVector == null) {
            this.addRawBlock(valueBlock, timestampBlock);
            return;
        }
        this.addRawVector(valueVector, timestampVector);
    }

    private void addRawVector(LongVector valueVector, LongVector timestampVector) {
        long timestampValue;
        long valueValue;
        int valuesPosition = 0;
        if (!this.state.seen() && valuesPosition < valueVector.getPositionCount()) {
            valueValue = valueVector.getLong(valuesPosition);
            timestampValue = timestampVector.getLong(valuesPosition);
            FirstLongByTimestampAggregator.first(this.state, valueValue, timestampValue);
            ++valuesPosition;
            this.state.seen(true);
        }
        while (valuesPosition < valueVector.getPositionCount()) {
            valueValue = valueVector.getLong(valuesPosition);
            timestampValue = timestampVector.getLong(valuesPosition);
            FirstLongByTimestampAggregator.combine(this.state, valueValue, timestampValue);
            ++valuesPosition;
        }
    }

    private void addRawVector(LongVector valueVector, LongVector timestampVector, BooleanVector mask) {
        long timestampValue;
        long valueValue;
        int valuesPosition;
        for (valuesPosition = 0; !this.state.seen() && valuesPosition < valueVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) {
                continue;
            }
            valueValue = valueVector.getLong(valuesPosition);
            timestampValue = timestampVector.getLong(valuesPosition);
            FirstLongByTimestampAggregator.first(this.state, valueValue, timestampValue);
            ++valuesPosition;
            this.state.seen(true);
            break;
        }
        while (valuesPosition < valueVector.getPositionCount()) {
            if (!mask.getBoolean(valuesPosition)) {
                ++valuesPosition;
                continue;
            }
            valueValue = valueVector.getLong(valuesPosition);
            timestampValue = timestampVector.getLong(valuesPosition);
            FirstLongByTimestampAggregator.combine(this.state, valueValue, timestampValue);
            ++valuesPosition;
        }
    }

    private void addRawBlock(LongBlock valueBlock, LongBlock timestampBlock) {
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            if (valueBlock.isNull(p) || timestampBlock.isNull(p)) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueBlock.getValueCount(p);
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                long valueValue = valueBlock.getLong(valueOffset);
                int timestampStart = timestampBlock.getFirstValueIndex(p);
                int timestampEnd = timestampStart + timestampBlock.getValueCount(p);
                for (int timestampOffset = timestampStart; timestampOffset < timestampEnd; ++timestampOffset) {
                    long timestampValue = timestampBlock.getLong(timestampOffset);
                    if (this.state.seen()) {
                        FirstLongByTimestampAggregator.combine(this.state, valueValue, timestampValue);
                        continue;
                    }
                    this.state.seen(true);
                    FirstLongByTimestampAggregator.first(this.state, valueValue, timestampValue);
                }
            }
        }
    }

    private void addRawBlock(LongBlock valueBlock, LongBlock timestampBlock, BooleanVector mask) {
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            if (!mask.getBoolean(p) || valueBlock.isNull(p) || timestampBlock.isNull(p)) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueBlock.getValueCount(p);
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                long valueValue = valueBlock.getLong(valueOffset);
                int timestampStart = timestampBlock.getFirstValueIndex(p);
                int timestampEnd = timestampStart + timestampBlock.getValueCount(p);
                for (int timestampOffset = timestampStart; timestampOffset < timestampEnd; ++timestampOffset) {
                    long timestampValue = timestampBlock.getLong(timestampOffset);
                    if (this.state.seen()) {
                        FirstLongByTimestampAggregator.combine(this.state, valueValue, timestampValue);
                        continue;
                    }
                    this.state.seen(true);
                    FirstLongByTimestampAggregator.first(this.state, valueValue, timestampValue);
                }
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + FirstLongByTimestampAggregatorFunction.intermediateStateDesc().size());
        Object timestampsUncast = page.getBlock(this.channels.get(0));
        if (timestampsUncast.areAllValuesNull()) {
            return;
        }
        LongVector timestamps = ((LongBlock)timestampsUncast).asVector();
        assert (timestamps.getPositionCount() == 1);
        Object valuesUncast = page.getBlock(this.channels.get(1));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        LongVector values = ((LongBlock)valuesUncast).asVector();
        assert (values.getPositionCount() == 1);
        Object seenUncast = page.getBlock(this.channels.get(2));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (seen.getPositionCount() == 1);
        FirstLongByTimestampAggregator.combineIntermediate(this.state, timestamps.getLong(0), values.getLong(0), seen.getBoolean(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        if (!this.state.seen()) {
            blocks[offset] = driverContext.blockFactory().newConstantNullBlock(1);
            return;
        }
        blocks[offset] = FirstLongByTimestampAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

