/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.analytics.ingest;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor2;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.application.analytics.ingest.AnalyticsEventEmitter;
import org.elasticsearch.xpack.application.analytics.ingest.AnalyticsEventIngestConfig;

@Deprecated
public class BulkProcessorFactory {
    private static final Logger logger = LogManager.getLogger(AnalyticsEventEmitter.class);
    private final AnalyticsEventIngestConfig config;
    private final Supplier<BulkProcessor2.Builder> builderSupplier;

    @Inject
    public BulkProcessorFactory(Client client, AnalyticsEventIngestConfig config) {
        OriginSettingClient originClient = new OriginSettingClient(client, "enterprise_search");
        this.builderSupplier = () -> BulkProcessorFactory.lambda$new$0((Client)originClient);
        this.config = config;
    }

    protected BulkProcessorFactory(AnalyticsEventIngestConfig config, Supplier<BulkProcessor2.Builder> builderSupplier) {
        this.builderSupplier = builderSupplier;
        this.config = config;
    }

    public BulkProcessor2 create() {
        return this.builderSupplier.get().setMaxNumberOfRetries(this.config.maxNumberOfRetries()).setBulkActions(this.config.maxNumberOfEventsPerBulk()).setFlushInterval(this.config.flushDelay()).setMaxBytesInFlight(this.config.maxBytesInFlight()).build();
    }

    private static /* synthetic */ BulkProcessor2.Builder lambda$new$0(Client originClient) {
        return BulkProcessor2.builder((arg_0, arg_1) -> ((Client)originClient).bulk(arg_0, arg_1), (BulkProcessor2.Listener)new BulkProcessorListener(), (ThreadPool)originClient.threadPool());
    }

    static class BulkProcessorListener
    implements BulkProcessor2.Listener {
        BulkProcessorListener() {
        }

        public void beforeBulk(long executionId, BulkRequest request) {
        }

        public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
            if (response.hasFailures()) {
                List failures = Arrays.stream(response.getItems()).filter(BulkItemResponse::isFailed).map(r -> r.getId() + " " + r.getFailureMessage()).collect(Collectors.toList());
                logger.error("Bulk write of behavioral analytics events encountered some failures: [{}]", new Object[]{failures});
            }
        }

        public void afterBulk(long executionId, BulkRequest request, Exception failure) {
            logger.error("Bulk write of " + request.numberOfActions() + " behavioral analytics events logs failed: " + failure.getMessage(), (Throwable)failure);
        }
    }
}

