/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.RecoverableCondition;
import org.ojalgo.array.operation.DOT;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.RawDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.matrix.store.RawStore;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;

final class RawCholesky
extends RawDecomposition
implements Cholesky<Double> {
    private double myMaxDiag = PrimitiveMath.ONE;
    private double myMinDiag = PrimitiveMath.ZERO;
    private boolean mySPD = false;

    RawCholesky() {
    }

    @Override
    public Double calculateDeterminant(Access2D<?> matrix) {
        double[][] retVal = this.reset(matrix, false);
        this.doDecompose(retVal, matrix);
        return this.getDeterminant();
    }

    @Override
    public boolean checkAndDecompose(MatrixStore<Double> matrix) {
        this.mySPD = matrix.isHermitian();
        if (this.mySPD) {
            double[][] retVal = this.reset(matrix, false);
            return this.doDecompose(retVal, matrix);
        }
        return this.computed(false);
    }

    @Override
    public int countSignificant(double threshold) {
        double minimum = Math.sqrt(threshold);
        RawStore internal = this.getInternalStore();
        int significant = 0;
        int limit = this.getMinDim();
        for (int ij = 0; ij < limit; ++ij) {
            if (!(internal.doubleValue(ij, ij) > minimum)) continue;
            ++significant;
        }
        return significant;
    }

    @Override
    public boolean decompose(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        double[][] retVal = this.reset(matrix, false);
        RawStore tmpRawInPlaceStore = this.getInternalStore();
        matrix.supplyTo(tmpRawInPlaceStore);
        return this.doDecompose(retVal, tmpRawInPlaceStore);
    }

    @Override
    public Double getDeterminant() {
        double[][] tmpData = this.getInternalData();
        int tmpMinDim = this.getMinDim();
        double retVal = PrimitiveMath.ONE;
        for (int ij = 0; ij < tmpMinDim; ++ij) {
            double tmpVal = tmpData[ij][ij];
            retVal *= tmpVal * tmpVal;
        }
        return retVal;
    }

    @Override
    public MatrixStore<Double> getInverse() {
        int tmpRowDim = this.getRowDim();
        return this.doGetInverse(this.allocate(tmpRowDim, tmpRowDim));
    }

    @Override
    public MatrixStore<Double> getInverse(PhysicalStore<Double> preallocated) {
        return this.doGetInverse(preallocated);
    }

    @Override
    public MatrixStore<Double> getL() {
        return this.getInternalStore().triangular(false, false);
    }

    @Override
    public double getRankThreshold() {
        return PrimitiveMath.TEN * this.myMaxDiag * this.getDimensionalEpsilon();
    }

    @Override
    public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs) {
        Primitive64Store tmpPreallocated = this.allocate(rhs.countRows(), rhs.countColumns());
        return this.getSolution(rhs, tmpPreallocated);
    }

    @Override
    public MatrixStore<Double> getSolution(Access2D.Collectable<Double, ? super PhysicalStore<Double>> rhs, PhysicalStore<Double> preallocated) {
        rhs.supplyTo(preallocated);
        return this.doSolve(preallocated);
    }

    @Override
    public MatrixStore<Double> invert(Access2D<?> original, PhysicalStore<Double> preallocated) throws RecoverableCondition {
        double[][] retVal = this.reset(original, false);
        this.doDecompose(retVal, original);
        if (this.isSolvable()) {
            return this.getInverse(preallocated);
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public boolean isSolvable() {
        return super.isSolvable();
    }

    @Override
    public boolean isSPD() {
        return this.mySPD;
    }

    @Override
    public PhysicalStore<Double> preallocate(Structure2D template) {
        return this.allocate(template.countRows(), template.countRows());
    }

    @Override
    public PhysicalStore<Double> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.allocate(templateBody.countRows(), templateRHS.countColumns());
    }

    @Override
    public MatrixStore<Double> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<Double> preallocated) throws RecoverableCondition {
        double[][] retVal = this.reset(body, false);
        this.doDecompose(retVal, body);
        if (this.isSolvable()) {
            preallocated.fillMatching(rhs);
            return this.doSolve(preallocated);
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    private boolean doDecompose(double[][] data, Access2D<?> input) {
        int tmpDiagDim = this.getRowDim();
        this.mySPD = this.getColDim() == tmpDiagDim;
        this.myMaxDiag = Double.MIN_NORMAL;
        this.myMinDiag = Double.MAX_VALUE;
        for (int ij = 0; this.mySPD && ij < tmpDiagDim; ++ij) {
            double[] tmpRowIJ = data[ij];
            double tmpVal = PrimitiveMath.MAX.invoke(input.doubleValue(ij, ij) - DOT.invoke(tmpRowIJ, 0, tmpRowIJ, 0, 0, ij), PrimitiveMath.ZERO);
            this.myMaxDiag = PrimitiveMath.MAX.invoke(this.myMaxDiag, tmpVal);
            this.myMinDiag = PrimitiveMath.MIN.invoke(this.myMinDiag, tmpVal);
            tmpVal = tmpRowIJ[ij] = PrimitiveMath.SQRT.invoke(tmpVal);
            this.mySPD = this.mySPD && tmpVal > PrimitiveMath.ZERO;
            for (int i = ij + 1; i < tmpDiagDim; ++i) {
                double[] tmpRowI = data[i];
                tmpRowI[ij] = (input.doubleValue(i, ij) - DOT.invoke(tmpRowI, 0, tmpRowIJ, 0, 0, ij)) / tmpVal;
            }
        }
        return this.computed(this.mySPD);
    }

    private MatrixStore<Double> doGetInverse(PhysicalStore<Double> preallocated) {
        RawStore body = this.getInternalStore();
        preallocated.substituteForwards(body, false, false, true);
        preallocated.substituteBackwards(body, false, true, true);
        return preallocated.hermitian(false);
    }

    private MatrixStore<Double> doSolve(PhysicalStore<Double> preallocated) {
        RawStore body = this.getInternalStore();
        preallocated.substituteForwards(body, false, false, false);
        preallocated.substituteBackwards(body, false, true, false);
        return preallocated;
    }

    @Override
    protected boolean checkSolvability() {
        return this.mySPD && this.myMinDiag > this.getRankThreshold();
    }
}

