/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.xcontent.AbstractObjectParser;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;

public final class ConstructingObjectParser<Value, Context>
extends AbstractObjectParser<Value, Context>
implements BiFunction<XContentParser, Context, Value>,
ContextParser<Context, Value> {
    private static final BiConsumer<?, ?> REQUIRED_CONSTRUCTOR_ARG_MARKER = (a, b) -> {
        throw new UnsupportedOperationException("I am just a marker I should never be called.");
    };
    private static final BiConsumer<?, ?> OPTIONAL_CONSTRUCTOR_ARG_MARKER = (a, b) -> {
        throw new UnsupportedOperationException("I am just a marker I should never be called.");
    };
    private final Map<RestApiVersion, List<ConstructorArgInfo>> constructorArgInfos = new EnumMap<RestApiVersion, List<ConstructorArgInfo>>(RestApiVersion.class);
    private final ObjectParser<Target, Context> objectParser;
    private final BiFunction<Object[], Context, Value> builder;
    private int numberOfFields = 0;

    public ConstructingObjectParser(String name, Function<Object[], Value> builder) {
        this(name, false, builder);
    }

    public ConstructingObjectParser(String name, boolean ignoreUnknownFields, Function<Object[], Value> builder) {
        this(name, ignoreUnknownFields, (Object[] args, Context context) -> builder.apply((Object[])args));
    }

    public ConstructingObjectParser(String name, boolean ignoreUnknownFields, BiFunction<Object[], Context, Value> builder) {
        this.objectParser = new ObjectParser(name, ignoreUnknownFields, null);
        this.builder = builder;
    }

    @Override
    public Value apply(XContentParser parser, Context context) {
        try {
            return this.parse(parser, context);
        }
        catch (IOException e) {
            throw new XContentParseException(parser.getTokenLocation(), "[" + this.objectParser.getName() + "] failed to parse object", e);
        }
    }

    @Override
    public Value parse(XContentParser parser, Context context) throws IOException {
        return this.objectParser.parse(parser, new Target(parser, context), context).finish();
    }

    public static <Value, FieldT> BiConsumer<Value, FieldT> constructorArg() {
        return REQUIRED_CONSTRUCTOR_ARG_MARKER;
    }

    public static <Value, FieldT> BiConsumer<Value, FieldT> optionalConstructorArg() {
        return OPTIONAL_CONSTRUCTOR_ARG_MARKER;
    }

    @Override
    public <T> void declareField(BiConsumer<Value, T> consumer, ContextParser<Context, T> parser, ParseField parseField, ObjectParser.ValueType type) {
        if (consumer == null) {
            throw new IllegalArgumentException("[consumer] is required");
        }
        if (parser == null) {
            throw new IllegalArgumentException("[parser] is required");
        }
        if (parseField == null) {
            throw new IllegalArgumentException("[parseField] is required");
        }
        if (type == null) {
            throw new IllegalArgumentException("[type] is required");
        }
        if (ConstructingObjectParser.isConstructorArg(consumer)) {
            Map<RestApiVersion, Integer> positions = this.addConstructorArg(consumer, parseField);
            this.objectParser.declareField((Value target, T v) -> target.constructorArg(positions, v), parser, parseField, type);
        } else {
            ++this.numberOfFields;
            this.objectParser.declareField(this.queueingConsumer(consumer, parseField), parser, parseField, type);
        }
    }

    @Override
    public <T> void declareObjectArrayOrNull(BiConsumer<Value, List<T>> consumer, ContextParser<Context, T> objectParser, ParseField field) {
        this.declareField(consumer, (XContentParser p, Context c) -> p.currentToken() == XContentParser.Token.VALUE_NULL ? null : ConstructingObjectParser.parseArray(p, c, objectParser), field, ObjectParser.ValueType.OBJECT_ARRAY_OR_NULL);
    }

    @Override
    public <T> void declareNamedObject(BiConsumer<Value, T> consumer, ObjectParser.NamedObjectParser<T, Context> namedObjectParser, ParseField parseField) {
        if (consumer == null) {
            throw new IllegalArgumentException("[consumer] is required");
        }
        if (namedObjectParser == null) {
            throw new IllegalArgumentException("[parser] is required");
        }
        if (parseField == null) {
            throw new IllegalArgumentException("[parseField] is required");
        }
        if (ConstructingObjectParser.isConstructorArg(consumer)) {
            Map<RestApiVersion, Integer> positions = this.addConstructorArg(consumer, parseField);
            this.objectParser.declareNamedObject((target, v) -> target.constructorArg(positions, v), namedObjectParser, parseField);
        } else {
            ++this.numberOfFields;
            this.objectParser.declareNamedObject(this.queueingConsumer(consumer, parseField), namedObjectParser, parseField);
        }
    }

    @Override
    public <T> void declareNamedObjects(BiConsumer<Value, List<T>> consumer, ObjectParser.NamedObjectParser<T, Context> namedObjectParser, ParseField parseField) {
        if (consumer == null) {
            throw new IllegalArgumentException("[consumer] is required");
        }
        if (namedObjectParser == null) {
            throw new IllegalArgumentException("[parser] is required");
        }
        if (parseField == null) {
            throw new IllegalArgumentException("[parseField] is required");
        }
        if (ConstructingObjectParser.isConstructorArg(consumer)) {
            Map<RestApiVersion, Integer> positions = this.addConstructorArg(consumer, parseField);
            this.objectParser.declareNamedObjects((target, v) -> target.constructorArg(positions, v), namedObjectParser, parseField);
        } else {
            ++this.numberOfFields;
            this.objectParser.declareNamedObjects(this.queueingConsumer(consumer, parseField), namedObjectParser, parseField);
        }
    }

    @Override
    public <T> void declareNamedObjects(BiConsumer<Value, List<T>> consumer, ObjectParser.NamedObjectParser<T, Context> namedObjectParser, Consumer<Value> orderedModeCallback, ParseField parseField) {
        if (consumer == null) {
            throw new IllegalArgumentException("[consumer] is required");
        }
        if (namedObjectParser == null) {
            throw new IllegalArgumentException("[parser] is required");
        }
        if (orderedModeCallback == null) {
            throw new IllegalArgumentException("[orderedModeCallback] is required");
        }
        if (parseField == null) {
            throw new IllegalArgumentException("[parseField] is required");
        }
        if (ConstructingObjectParser.isConstructorArg(consumer)) {
            Map<RestApiVersion, Integer> positions = this.addConstructorArg(consumer, parseField);
            this.objectParser.declareNamedObjects((target, v) -> target.constructorArg(positions, v), namedObjectParser, this.wrapOrderedModeCallBack(orderedModeCallback), parseField);
        } else {
            ++this.numberOfFields;
            this.objectParser.declareNamedObjects(this.queueingConsumer(consumer, parseField), namedObjectParser, this.wrapOrderedModeCallBack(orderedModeCallback), parseField);
        }
    }

    int getNumberOfFields() {
        assert (this.constructorArgInfos.get(RestApiVersion.current()).size() == this.constructorArgInfos.get(RestApiVersion.minimumSupported()).size()) : "Constructors must have same number of arguments per all compatible versions";
        return this.constructorArgInfos.get(RestApiVersion.current()).size();
    }

    private static boolean isConstructorArg(BiConsumer<?, ?> consumer) {
        return consumer == REQUIRED_CONSTRUCTOR_ARG_MARKER || consumer == OPTIONAL_CONSTRUCTOR_ARG_MARKER;
    }

    private Map<RestApiVersion, Integer> addConstructorArg(BiConsumer<?, ?> consumer, ParseField parseField) {
        boolean required;
        boolean bl = required = consumer == REQUIRED_CONSTRUCTOR_ARG_MARKER;
        if (RestApiVersion.minimumSupported().matches(parseField.getForRestApiVersion())) {
            this.constructorArgInfos.computeIfAbsent(RestApiVersion.minimumSupported(), v -> new ArrayList()).add(new ConstructorArgInfo(parseField, required));
        }
        if (RestApiVersion.current().matches(parseField.getForRestApiVersion())) {
            this.constructorArgInfos.computeIfAbsent(RestApiVersion.current(), v -> new ArrayList()).add(new ConstructorArgInfo(parseField, required));
        }
        return this.constructorArgInfos.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> ((List)e.getValue()).size()));
    }

    @Override
    public String getName() {
        return this.objectParser.getName();
    }

    @Override
    public void declareRequiredFieldSet(String ... requiredSet) {
        this.objectParser.declareRequiredFieldSet(requiredSet);
    }

    @Override
    public void declareExclusiveFieldSet(String ... exclusiveSet) {
        this.objectParser.declareExclusiveFieldSet(exclusiveSet);
    }

    private Consumer<Target> wrapOrderedModeCallBack(Consumer<Value> callback) {
        return target -> {
            if (target.targetObject != null) {
                callback.accept(target.targetObject);
                return;
            }
            target.queuedOrderedModeCallback = callback;
        };
    }

    private <T> BiConsumer<Target, T> queueingConsumer(BiConsumer<Value, T> consumer, ParseField parseField) {
        return (target, v) -> {
            if (target.targetObject != null) {
                consumer.accept(target.targetObject, v);
                return;
            }
            XContentLocation location = target.parser.getTokenLocation();
            target.queue(targetObject -> {
                try {
                    consumer.accept(targetObject, v);
                }
                catch (Exception e) {
                    throw new XContentParseException(location, "[" + this.objectParser.getName() + "] failed to parse field [" + parseField.getPreferredName() + "]", e);
                }
            });
        };
    }

    private class Target {
        private final Object[] constructorArgs;
        private final XContentParser parser;
        private final Context context;
        private int constructorArgsCollected = 0;
        private Consumer<Value>[] queuedFields;
        private Consumer<Value> queuedOrderedModeCallback;
        private int queuedFieldsCount = 0;
        private Value targetObject;

        Target(XContentParser parser, Context context) {
            this.parser = parser;
            this.context = context;
            this.constructorArgs = new Object[ConstructingObjectParser.this.constructorArgInfos.getOrDefault(parser.getRestApiVersion(), Collections.emptyList()).size()];
        }

        private void constructorArg(Map<RestApiVersion, Integer> positions, Object value) {
            int position = positions.get(this.parser.getRestApiVersion()) - 1;
            this.constructorArgs[position] = value;
            ++this.constructorArgsCollected;
            if (this.constructorArgsCollected == ConstructingObjectParser.this.constructorArgInfos.get(this.parser.getRestApiVersion()).size()) {
                this.buildTarget();
            }
        }

        private void queue(Consumer<Value> queueMe) {
            assert (this.targetObject == null) : "Don't queue after the targetObject has been built! Just apply the consumer directly.";
            if (this.queuedFields == null) {
                this.queuedFields = new Consumer[ConstructingObjectParser.this.numberOfFields];
            }
            this.queuedFields[this.queuedFieldsCount] = queueMe;
            ++this.queuedFieldsCount;
        }

        private Value finish() {
            if (this.targetObject != null) {
                return this.targetObject;
            }
            StringBuilder message = null;
            for (int i = 0; i < this.constructorArgs.length; ++i) {
                if (this.constructorArgs[i] != null) continue;
                ConstructorArgInfo arg = ConstructingObjectParser.this.constructorArgInfos.get(this.parser.getRestApiVersion()).get(i);
                if (!arg.required) continue;
                if (message == null) {
                    message = new StringBuilder("Required [").append(arg.field);
                    continue;
                }
                message.append(", ").append(arg.field);
            }
            if (message != null) {
                throw new IllegalArgumentException(message.append(']').toString());
            }
            assert (!ConstructingObjectParser.this.constructorArgInfos.isEmpty()) : "[" + ConstructingObjectParser.this.objectParser.getName() + "] must configure at least one constructor argument. If it doesn't have any it should use ObjectParser instead of ConstructingObjectParser. This is a bug in the parser declaration.";
            this.buildTarget();
            return this.targetObject;
        }

        private void buildTarget() {
            try {
                this.targetObject = ConstructingObjectParser.this.builder.apply(this.constructorArgs, this.context);
                if (this.queuedOrderedModeCallback != null) {
                    this.queuedOrderedModeCallback.accept(this.targetObject);
                }
                while (this.queuedFieldsCount > 0) {
                    --this.queuedFieldsCount;
                    this.queuedFields[this.queuedFieldsCount].accept(this.targetObject);
                }
            }
            catch (XContentParseException e) {
                throw new XContentParseException(e.getLocation(), "failed to build [" + ConstructingObjectParser.this.objectParser.getName() + "] after last required field arrived", e);
            }
            catch (Exception e) {
                throw new XContentParseException(null, "Failed to build [" + ConstructingObjectParser.this.objectParser.getName() + "] after last required field arrived", e);
            }
        }
    }

    private static class ConstructorArgInfo {
        final ParseField field;
        final boolean required;

        ConstructorArgInfo(ParseField field, boolean required) {
            this.field = field;
            this.required = required;
        }
    }
}

