/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.search;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Streams;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.indices.ExecutorNames;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.rest.action.admin.indices.AliasesNotFoundException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.EnterpriseSearch;
import org.elasticsearch.xpack.application.search.SearchApplication;
import org.elasticsearch.xpack.application.search.SearchApplicationListItem;

public class SearchApplicationIndexService {
    private static final Logger logger = LogManager.getLogger(SearchApplicationIndexService.class);
    public static final String SEARCH_APPLICATION_ALIAS_NAME = ".search-app";
    public static final String SEARCH_APPLICATION_CONCRETE_INDEX_NAME = ".search-app-1";
    public static final String SEARCH_APPLICATION_INDEX_NAME_PATTERN = ".search-app-*";
    private static final int SEARCH_APPLICATION_INDEX_MAPPINGS_VERSION = 1;
    private final Client client;
    private final Client clientWithOrigin;
    private final ClusterService clusterService;
    public final NamedWriteableRegistry namedWriteableRegistry;
    private final BigArrays bigArrays;

    public SearchApplicationIndexService(Client client, ClusterService clusterService, NamedWriteableRegistry namedWriteableRegistry, BigArrays bigArrays) {
        this.client = client;
        this.clientWithOrigin = new OriginSettingClient(client, "enterprise_search");
        this.clusterService = clusterService;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.bigArrays = bigArrays;
    }

    public static SystemIndexDescriptor getSystemIndexDescriptor() {
        return SystemIndexDescriptor.builder().setIndexPattern(SEARCH_APPLICATION_INDEX_NAME_PATTERN).setPrimaryIndex(SEARCH_APPLICATION_CONCRETE_INDEX_NAME).setDescription("Contains Search Application configuration").setMappings(SearchApplicationIndexService.getIndexMappings()).setSettings(SearchApplicationIndexService.getIndexSettings()).setAliasName(SEARCH_APPLICATION_ALIAS_NAME).setOrigin("enterprise_search").setThreadPools(ExecutorNames.DEFAULT_SYSTEM_INDEX_THREAD_POOLS).build();
    }

    private static Settings getIndexSettings() {
        return Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1").put("index.priority", 100).put("index.refresh_interval", "1s").build();
    }

    private static XContentBuilder getIndexMappings() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder.startObject("_meta");
            builder.field("version", Version.CURRENT.toString());
            builder.field("managed_index_mappings_version", 1);
            builder.endObject();
            builder.field("dynamic", "strict");
            builder.startObject("properties");
            builder.startObject(SearchApplication.NAME_FIELD.getPreferredName());
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject(SearchApplication.ANALYTICS_COLLECTION_NAME_FIELD.getPreferredName());
            builder.field("type", "keyword");
            builder.endObject();
            builder.startObject(SearchApplication.UPDATED_AT_MILLIS_FIELD.getPreferredName());
            builder.field("type", "long");
            builder.endObject();
            builder.startObject(SearchApplication.BINARY_CONTENT_FIELD.getPreferredName());
            builder.field("type", "object");
            builder.field("enabled", "false");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            logger.fatal("Failed to build .search-app-1 index mappings", (Throwable)e);
            throw new UncheckedIOException("Failed to build .search-app-1 index mappings", e);
        }
    }

    public void getSearchApplication(String resourceName, ActionListener<SearchApplication> listener) {
        GetRequest getRequest = new GetRequest(SEARCH_APPLICATION_ALIAS_NAME).id(resourceName).realtime(true);
        this.clientWithOrigin.get(getRequest, new DelegatingIndexNotFoundActionListener<GetResponse, SearchApplication>(resourceName, listener, (l, getResponse) -> {
            if (!getResponse.isExists()) {
                l.onFailure((Exception)((Object)new ResourceNotFoundException(resourceName, new Object[0])));
                return;
            }
            BytesReference source = getResponse.getSourceInternal();
            SearchApplication searchApplication = this.parseSearchApplicationBinaryFromSource(source, this.getAliasIndices(resourceName));
            l.onResponse((Object)searchApplication);
        }));
    }

    private String[] getAliasIndices(String searchApplicationName) {
        return (String[])this.clusterService.state().metadata().getProject().aliasedIndices(searchApplicationName).stream().map(Index::getName).toArray(String[]::new);
    }

    private static String getSearchAliasName(SearchApplication app) {
        return app.name();
    }

    public void putSearchApplication(final SearchApplication app, final boolean create, final ActionListener<DocWriteResponse> listener) {
        this.createOrUpdateAlias(app, new ActionListener<IndicesAliasesResponse>(){

            public void onResponse(IndicesAliasesResponse response) {
                SearchApplicationIndexService.this.updateSearchApplication(app, create, (ActionListener<DocWriteResponse>)listener);
            }

            public void onFailure(Exception e) {
                Exception failException = e;
                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                if (cause instanceof IndexNotFoundException) {
                    failException = new IllegalArgumentException(cause.getMessage(), cause);
                }
                listener.onFailure(failException);
            }
        });
    }

    private void createOrUpdateAlias(SearchApplication app, ActionListener<IndicesAliasesResponse> listener) {
        Metadata metadata = this.clusterService.state().metadata();
        String searchAliasName = SearchApplicationIndexService.getSearchAliasName(app);
        IndicesAliasesRequestBuilder requestBuilder = null;
        if (metadata.getProject().hasAlias(searchAliasName)) {
            Set<String> currentAliases = metadata.getProject().aliasedIndices(searchAliasName).stream().map(Index::getName).collect(Collectors.toSet());
            Set<String> targetAliases = Set.of(app.indices());
            requestBuilder = this.updateAliasIndices(currentAliases, targetAliases, searchAliasName);
        } else {
            requestBuilder = this.client.admin().indices().prepareAliases(EnterpriseSearch.HARD_CODED_ENTERPRISE_SEARCH_MASTER_NODE_TIMEOUT, EnterpriseSearch.HARD_CODED_ENTERPRISE_SEARCH_MASTER_NODE_TIMEOUT).addAlias(app.indices(), searchAliasName);
        }
        requestBuilder.execute(listener);
    }

    private IndicesAliasesRequestBuilder updateAliasIndices(Set<String> currentAliases, Set<String> targetAliases, String searchAliasName) {
        HashSet<String> deleteIndices = new HashSet<String>(currentAliases);
        deleteIndices.removeAll(targetAliases);
        IndicesAliasesRequestBuilder aliasesRequestBuilder = this.client.admin().indices().prepareAliases(EnterpriseSearch.HARD_CODED_ENTERPRISE_SEARCH_MASTER_NODE_TIMEOUT, EnterpriseSearch.HARD_CODED_ENTERPRISE_SEARCH_MASTER_NODE_TIMEOUT);
        for (String newIndex : targetAliases) {
            aliasesRequestBuilder.addAliasAction(IndicesAliasesRequest.AliasActions.add().index(newIndex).alias(searchAliasName));
        }
        for (String deleteIndex : deleteIndices) {
            aliasesRequestBuilder.addAliasAction(IndicesAliasesRequest.AliasActions.remove().index(deleteIndex).alias(searchAliasName));
        }
        return aliasesRequestBuilder;
    }

    private void updateSearchApplication(SearchApplication app, boolean create, ActionListener<DocWriteResponse> listener) {
        try (ReleasableBytesStreamOutput buffer = new ReleasableBytesStreamOutput(0, this.bigArrays.withCircuitBreaking());){
            try (XContentBuilder source = XContentFactory.jsonBuilder((OutputStream)buffer);){
                source.startObject().field(SearchApplication.NAME_FIELD.getPreferredName(), app.name()).field(SearchApplication.ANALYTICS_COLLECTION_NAME_FIELD.getPreferredName(), app.analyticsCollectionName()).field(SearchApplication.UPDATED_AT_MILLIS_FIELD.getPreferredName(), app.updatedAtMillis()).directFieldAsBase64(SearchApplication.BINARY_CONTENT_FIELD.getPreferredName(), os -> SearchApplicationIndexService.writeSearchApplicationBinaryWithVersion(app, os, this.clusterService.state().getMinTransportVersion())).endObject();
            }
            DocWriteRequest.OpType opType = create ? DocWriteRequest.OpType.CREATE : DocWriteRequest.OpType.INDEX;
            IndexRequest indexRequest = ((IndexRequest)new IndexRequest(SEARCH_APPLICATION_ALIAS_NAME).opType(DocWriteRequest.OpType.INDEX).id(app.name()).opType(opType).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).source(buffer.bytes(), XContentType.JSON);
            this.clientWithOrigin.index(indexRequest, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void deleteSearchApplication(String resourceName, ActionListener<DeleteResponse> listener) {
        try {
            DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(SEARCH_APPLICATION_ALIAS_NAME).id(resourceName).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.clientWithOrigin.delete(deleteRequest, new DelegatingIndexNotFoundActionListener<DeleteResponse, DeleteResponse>(resourceName, listener, (l, deleteResponse) -> {
                if (deleteResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)((Object)new ResourceNotFoundException(resourceName, new Object[0])));
                    return;
                }
                l.onResponse(deleteResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void removeAlias(String searchAliasName, final ActionListener<AcknowledgedResponse> listener) {
        IndicesAliasesRequest aliasesRequest = new IndicesAliasesRequest(EnterpriseSearch.HARD_CODED_ENTERPRISE_SEARCH_MASTER_NODE_TIMEOUT, EnterpriseSearch.HARD_CODED_ENTERPRISE_SEARCH_MASTER_NODE_TIMEOUT).addAliasAction(IndicesAliasesRequest.AliasActions.remove().aliases(new String[]{searchAliasName}).indices(new String[]{"*"}));
        this.client.admin().indices().aliases(aliasesRequest, (ActionListener)new ActionListener<IndicesAliasesResponse>(this){

            public void onResponse(IndicesAliasesResponse response) {
                listener.onResponse((Object)response);
            }

            public void onFailure(Exception e) {
                if (e instanceof ResourceNotFoundException) {
                    listener.onResponse((Object)IndicesAliasesResponse.ACKNOWLEDGED_NO_ERRORS);
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }

    public void deleteSearchApplicationAndAlias(final String resourceName, final ActionListener<DeleteResponse> listener) {
        this.removeAlias(resourceName, new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                SearchApplicationIndexService.this.deleteSearchApplication(resourceName, (ActionListener<DeleteResponse>)listener);
            }

            public void onFailure(Exception e) {
                if (e instanceof AliasesNotFoundException) {
                    SearchApplicationIndexService.this.deleteSearchApplication(resourceName, (ActionListener<DeleteResponse>)listener);
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }

    public void listSearchApplication(String queryString, int from, int size, final ActionListener<SearchApplicationResult> listener) {
        try {
            SearchSourceBuilder source = new SearchSourceBuilder().from(from).size(size).query((QueryBuilder)new QueryStringQueryBuilder(queryString)).docValueField(SearchApplication.NAME_FIELD.getPreferredName()).docValueField(SearchApplication.ANALYTICS_COLLECTION_NAME_FIELD.getPreferredName()).docValueField(SearchApplication.UPDATED_AT_MILLIS_FIELD.getPreferredName()).storedFields(Collections.singletonList("_none_")).sort(SearchApplication.NAME_FIELD.getPreferredName(), SortOrder.ASC);
            SearchRequest req = new SearchRequest(new String[]{SEARCH_APPLICATION_ALIAS_NAME}).source(source);
            this.clientWithOrigin.search(req, (ActionListener)new ActionListener<SearchResponse>(this){

                public void onResponse(SearchResponse searchResponse) {
                    listener.onResponse((Object)SearchApplicationIndexService.mapSearchResponse(searchResponse));
                }

                public void onFailure(Exception e) {
                    if (e instanceof IndexNotFoundException) {
                        listener.onResponse((Object)new SearchApplicationResult(Collections.emptyList(), 0L));
                        return;
                    }
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private static SearchApplicationResult mapSearchResponse(SearchResponse response) {
        List<SearchApplicationListItem> apps = Arrays.stream(response.getHits().getHits()).map(SearchApplicationIndexService::hitToSearchApplicationListItem).toList();
        return new SearchApplicationResult(apps, (int)response.getHits().getTotalHits().value());
    }

    private static SearchApplicationListItem hitToSearchApplicationListItem(SearchHit searchHit) {
        Map documentFields = searchHit.getDocumentFields();
        String resourceName = (String)((DocumentField)documentFields.get(SearchApplication.NAME_FIELD.getPreferredName())).getValue();
        return new SearchApplicationListItem(resourceName, (String)((DocumentField)documentFields.get(SearchApplication.ANALYTICS_COLLECTION_NAME_FIELD.getPreferredName())).getValue(), (Long)((DocumentField)documentFields.get(SearchApplication.UPDATED_AT_MILLIS_FIELD.getPreferredName())).getValue());
    }

    /*
     * Exception decompiling
     */
    private SearchApplication parseSearchApplicationBinaryFromSource(BytesReference source, String[] indices) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static SearchApplication parseSearchApplicationBinaryWithVersion(StreamInput in, String[] indices) throws IOException {
        TransportVersion version = TransportVersion.readVersion((StreamInput)in);
        assert (version.onOrBefore((VersionId)TransportVersion.current())) : String.valueOf(version) + " >= " + String.valueOf(TransportVersion.current());
        in.setTransportVersion(version);
        return new SearchApplication(in, indices);
    }

    static void writeSearchApplicationBinaryWithVersion(SearchApplication app, OutputStream os, TransportVersion minTransportVersion) throws IOException {
        os = Streams.noCloseStream((OutputStream)os);
        TransportVersion.writeVersion((TransportVersion)minTransportVersion, (StreamOutput)new OutputStreamStreamOutput(os));
        try (OutputStreamStreamOutput out = new OutputStreamStreamOutput(os);){
            out.setTransportVersion(minTransportVersion);
            app.writeTo((StreamOutput)out);
        }
    }

    static class DelegatingIndexNotFoundActionListener<T, R>
    extends DelegatingActionListener<T, R> {
        private final BiConsumer<ActionListener<R>, T> bc;
        private final String resourceName;

        DelegatingIndexNotFoundActionListener(String resourceName, ActionListener<R> delegate, BiConsumer<ActionListener<R>, T> bc) {
            super(delegate);
            this.bc = bc;
            this.resourceName = resourceName;
        }

        public void onResponse(T t) {
            this.bc.accept((ActionListener<R>)this.delegate, (ActionListener)t);
        }

        public void onFailure(Exception e) {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            if (cause instanceof IndexNotFoundException) {
                this.delegate.onFailure((Exception)((Object)new ResourceNotFoundException(this.resourceName, new Object[0])));
                return;
            }
            this.delegate.onFailure(e);
        }
    }

    public record SearchApplicationResult(List<SearchApplicationListItem> items, long totalResults) {
    }
}

