/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms.scheduling;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

class MonotonicClock
extends Clock {
    private final Clock internalClock;
    private final AtomicReference<Instant> latestInstant;

    MonotonicClock(Clock clock) {
        this.internalClock = Objects.requireNonNull(clock);
        this.latestInstant = new AtomicReference<Instant>(clock.instant());
    }

    @Override
    public ZoneId getZone() {
        return this.internalClock.getZone();
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return this.internalClock.withZone(zone);
    }

    @Override
    public Instant instant() {
        Instant current = this.internalClock.instant();
        return this.latestInstant.updateAndGet(previousLatest -> current.isAfter((Instant)previousLatest) ? current : previousLatest);
    }
}

