/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesRequest;
import org.elasticsearch.xpack.core.action.AbstractTransportGetResourcesAction;
import org.elasticsearch.xpack.core.action.util.ExpandedIdsMatcher;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.common.time.RemainingTime;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.action.GetTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.transform.transforms.TransformNodes;
import org.elasticsearch.xpack.transform.transforms.TransformTask;

public class TransportGetTransformAction
extends AbstractTransportGetResourcesAction<TransformConfig, GetTransformAction.Request, GetTransformAction.Response> {
    private static final String DANGLING_TASK_ERROR_MESSAGE_FORMAT = "Found task for transform [%s], but no configuration for it. To delete this transform use DELETE with force=true.";
    private final ClusterService clusterService;
    private final Client client;

    @Inject
    public TransportGetTransformAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Client client, NamedXContentRegistry xContentRegistry) {
        super("cluster:monitor/transform/get", transportService, actionFilters, GetTransformAction.Request::new, client, xContentRegistry);
        this.clusterService = clusterService;
        this.client = client;
    }

    protected void doExecute(Task task, GetTransformAction.Request request, ActionListener<GetTransformAction.Response> listener) {
        TaskId parentTaskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        ClusterState clusterState = this.clusterService.state();
        TransformNodes.warnIfNoTransformNodes(clusterState);
        RemainingTime remainingTime = RemainingTime.from(Instant::now, (TimeValue)request.timeout());
        ActionListener searchTransformConfigsListener = listener.delegateFailureAndWrap((l, r) -> {
            if (request.checkForDanglingTasks()) {
                this.getAllTransformIds(request, (QueryPage<TransformConfig>)r, remainingTime, (ActionListener<Set<String>>)l.delegateFailureAndWrap((ll, transformConfigIds) -> {
                    List<GetTransformAction.Response.Error> errors = TransformTask.findTransformTasks(request.getId(), clusterState).stream().map(PersistentTasksCustomMetadata.PersistentTask::getId).filter(Predicate.not(transformConfigIds::contains)).map(transformId -> new GetTransformAction.Response.Error("dangling_task", Strings.format((String)DANGLING_TASK_ERROR_MESSAGE_FORMAT, (Object[])new Object[]{transformId}))).toList();
                    ll.onResponse((Object)new GetTransformAction.Response(r.results(), r.count(), errors.isEmpty() ? null : errors));
                }));
            } else {
                l.onResponse((Object)new GetTransformAction.Response(r.results(), r.count(), null));
            }
        });
        this.searchResources((AbstractGetResourcesRequest)request, parentTaskId, searchTransformConfigsListener);
    }

    protected ParseField getResultsField() {
        return TransformField.TRANSFORMS;
    }

    protected String[] getIndices() {
        return new String[]{".transform-internal-*", ".data-frame-internal-*"};
    }

    protected TransformConfig parse(XContentParser parser) {
        return TransformConfig.fromXContent((XContentParser)parser, null, (boolean)true);
    }

    protected ResourceNotFoundException notFoundException(String resourceId) {
        return new ResourceNotFoundException(TransformMessages.getMessage((String)"Transform with id [{0}] could not be found", (Object[])new Object[]{resourceId}), new Object[0]);
    }

    protected String executionOrigin() {
        return "transform";
    }

    protected String extractIdFromResource(TransformConfig transformConfig) {
        return transformConfig.getId();
    }

    protected QueryBuilder additionalQuery() {
        return QueryBuilders.termQuery((String)TransformField.INDEX_DOC_TYPE.getPreferredName(), (String)"data_frame_transform_config");
    }

    protected SearchSourceBuilder customSearchOptions(SearchSourceBuilder searchSourceBuilder) {
        return searchSourceBuilder.sort("_index", SortOrder.DESC).sort(TransformField.ID.getPreferredName(), SortOrder.ASC);
    }

    private void getAllTransformIds(GetTransformAction.Request request, QueryPage<TransformConfig> initialResults, RemainingTime remainingTime, ActionListener<Set<String>> listener) {
        ActionListener transformIdListener = listener.map(stream -> stream.collect(Collectors.toSet()));
        Stream<String> requestedPage = initialResults.results().stream().map(TransformConfig::getId);
        if (initialResults.count() == (long)initialResults.results().size()) {
            transformIdListener.onResponse(requestedPage);
        } else {
            int from = request.getPageParams().getFrom();
            int size = request.getPageParams().getSize();
            String[] idTokens = ExpandedIdsMatcher.tokenizeExpression((String)request.getResourceId());
            this.getAllTransformIds(idTokens, false, from, size, remainingTime, (ActionListener<Stream<String>>)transformIdListener.delegateFailureAndWrap((l, nextPages) -> {
                Stream currentPages = Stream.concat(requestedPage, nextPages);
                this.getAllTransformIds(idTokens, true, from, size, remainingTime, (ActionListener<Stream<String>>)l.map(firstPages -> Stream.concat(firstPages, currentPages)));
            }));
        }
    }

    private void getAllTransformIds(String[] idTokens, boolean reverse, int from, int size, RemainingTime remainingTime, ActionListener<Stream<String>> listener) {
        if (reverse && from <= 0) {
            listener.onResponse(Stream.empty());
            return;
        }
        int thisPage = reverse ? from - size : from + size;
        int thisPageFrom = Math.max(0, thisPage);
        int thisPageSize = thisPage < 0 ? from : size;
        SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".transform-internal-*", ".data-frame-internal-*"}).addSort(TransformField.ID.getPreferredName(), SortOrder.ASC).addSort("_index", SortOrder.DESC).setFrom(thisPageFrom).setSize(thisPageSize).setTimeout((TimeValue)remainingTime.get()).setFetchSource(false).setTrackTotalHits(true).addDocValueField(TransformField.ID.getPreferredName()).setQuery(TransportGetTransformAction.query(idTokens)).request();
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"transform", (Object)request, (ActionListener)listener.delegateFailureAndWrap((l, searchResponse) -> {
            Stream transformIds = Arrays.stream(searchResponse.getHits().getHits()).map(hit -> (String)hit.field(TransformField.ID.getPreferredName()).getValue()).filter(Predicate.not(org.elasticsearch.common.Strings::isNullOrEmpty)).toList().stream();
            if (searchResponse.getHits().getHits().length == size) {
                this.getAllTransformIds(idTokens, reverse, thisPageFrom, thisPageSize, remainingTime, (ActionListener<Stream<String>>)l.map(nextTransformIds -> Stream.concat(transformIds, nextTransformIds)));
            } else {
                l.onResponse(transformIds);
            }
        }), (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    private static QueryBuilder query(String[] idTokens) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)TransformField.INDEX_DOC_TYPE.getPreferredName(), (String)"data_frame_transform_config"));
        if (!org.elasticsearch.common.Strings.isAllOrWildcard((String[])idTokens)) {
            BoolQueryBuilder shouldQueries = new BoolQueryBuilder();
            ArrayList<String> terms = new ArrayList<String>();
            for (String token : idTokens) {
                if (Regex.isSimpleMatchPattern((String)token)) {
                    shouldQueries.should((QueryBuilder)QueryBuilders.wildcardQuery((String)TransformField.ID.getPreferredName(), (String)token));
                    continue;
                }
                terms.add(token);
            }
            if (!terms.isEmpty()) {
                shouldQueries.should((QueryBuilder)QueryBuilders.termsQuery((String)TransformField.ID.getPreferredName(), terms));
            }
            if (!shouldQueries.should().isEmpty()) {
                queryBuilder.filter((QueryBuilder)shouldQueries);
            }
        }
        return QueryBuilders.constantScoreQuery((QueryBuilder)queryBuilder);
    }
}

