/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.options.action;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.datastreams.DataStreamsActionUtil;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.local.TransportLocalProjectMetadataAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.datastreams.options.action.GetDataStreamOptionsAction;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetDataStreamOptionsAction
extends TransportLocalProjectMetadataAction<GetDataStreamOptionsAction.Request, GetDataStreamOptionsAction.Response> {
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final SystemIndices systemIndices;
    private final ThreadPool threadPool;

    @Inject
    public TransportGetDataStreamOptionsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices) {
        super(GetDataStreamOptionsAction.INSTANCE.name(), actionFilters, transportService.getTaskManager(), clusterService, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE, projectResolver);
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.systemIndices = systemIndices;
        this.threadPool = threadPool;
        transportService.registerRequestHandler(this.actionName, this.executor, false, true, GetDataStreamOptionsAction.Request::new, (request, channel, task) -> this.executeDirect(task, (ActionRequest)request, (ActionListener)new ChannelActionListener(channel)));
    }

    protected void localClusterStateOperation(Task task, GetDataStreamOptionsAction.Request request, ProjectState state, ActionListener<GetDataStreamOptionsAction.Response> listener) {
        ((CancellableTask)task).ensureNotCancelled();
        List requestedDataStreams = DataStreamsActionUtil.getDataStreamNames((IndexNameExpressionResolver)this.indexNameExpressionResolver, (ProjectMetadata)state.metadata(), (String[])request.getNames(), (IndicesOptions)request.indicesOptions());
        Map dataStreams = state.metadata().dataStreams();
        for (String name : requestedDataStreams) {
            this.systemIndices.validateDataStreamAccess(name, this.threadPool.getThreadContext());
        }
        listener.onResponse((Object)new GetDataStreamOptionsAction.Response(requestedDataStreams.stream().map(dataStreams::get).filter(Objects::nonNull).map(dataStream -> new GetDataStreamOptionsAction.Response.DataStreamEntry(dataStream.getName(), dataStream.getDataStreamOptions())).sorted(Comparator.comparing(GetDataStreamOptionsAction.Response.DataStreamEntry::dataStreamName)).toList()));
    }

    protected ClusterBlockException checkBlock(GetDataStreamOptionsAction.Request request, ProjectState state) {
        return state.blocks().globalBlockedException(state.projectId(), ClusterBlockLevel.METADATA_READ);
    }
}

