/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.options.action;

import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.datastreams.DataStreamsActionUtil;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeProjectAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataDataStreamsService;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.datastreams.options.action.DeleteDataStreamOptionsAction;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteDataStreamOptionsAction
extends AcknowledgedTransportMasterNodeProjectAction<DeleteDataStreamOptionsAction.Request> {
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final MetadataDataStreamsService metadataDataStreamsService;
    private final SystemIndices systemIndices;

    @Inject
    public TransportDeleteDataStreamOptionsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver, MetadataDataStreamsService metadataDataStreamsService, SystemIndices systemIndices) {
        super(DeleteDataStreamOptionsAction.INSTANCE.name(), transportService, clusterService, threadPool, actionFilters, DeleteDataStreamOptionsAction.Request::new, projectResolver, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.metadataDataStreamsService = metadataDataStreamsService;
        this.systemIndices = systemIndices;
    }

    protected void masterOperation(Task task, DeleteDataStreamOptionsAction.Request request, ProjectState state, ActionListener<AcknowledgedResponse> listener) {
        List dataStreamNames = DataStreamsActionUtil.getDataStreamNames((IndexNameExpressionResolver)this.indexNameExpressionResolver, (ProjectMetadata)state.metadata(), (String[])request.getNames(), (IndicesOptions)request.indicesOptions());
        for (String name : dataStreamNames) {
            this.systemIndices.validateDataStreamAccess(name, this.threadPool.getThreadContext());
        }
        this.metadataDataStreamsService.removeDataStreamOptions(state.projectId(), dataStreamNames, request.ackTimeout(), request.masterNodeTimeout(), listener);
    }

    protected ClusterBlockException checkBlock(DeleteDataStreamOptionsAction.Request request, ProjectState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

