/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle.action;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;

public class GetDataStreamLifecycleStatsAction
extends ActionType<Response> {
    public static final GetDataStreamLifecycleStatsAction INSTANCE = new GetDataStreamLifecycleStatsAction();
    public static final String NAME = "cluster:monitor/data_stream/lifecycle/stats";

    private GetDataStreamLifecycleStatsAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ChunkedToXContentObject {
        private final Long runDuration;
        private final Long timeBetweenStarts;
        private final List<DataStreamStats> dataStreamStats;

        public Response(@Nullable Long runDuration, @Nullable Long timeBetweenStarts, List<DataStreamStats> dataStreamStats) {
            this.runDuration = runDuration;
            this.timeBetweenStarts = timeBetweenStarts;
            this.dataStreamStats = dataStreamStats;
        }

        public Response(StreamInput in) throws IOException {
            this.runDuration = in.readOptionalVLong();
            this.timeBetweenStarts = in.readOptionalVLong();
            this.dataStreamStats = in.readCollectionAsImmutableList(DataStreamStats::read);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalVLong(this.runDuration);
            out.writeOptionalVLong(this.timeBetweenStarts);
            out.writeCollection(this.dataStreamStats, StreamOutput::writeWriteable);
        }

        public Long getRunDuration() {
            return this.runDuration;
        }

        public Long getTimeBetweenStarts() {
            return this.timeBetweenStarts;
        }

        public List<DataStreamStats> getDataStreamStats() {
            return this.dataStreamStats;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response other = (Response)((Object)o);
            return Objects.equals(this.runDuration, other.runDuration) && Objects.equals(this.timeBetweenStarts, other.timeBetweenStarts) && Objects.equals(this.dataStreamStats, other.dataStreamStats);
        }

        public int hashCode() {
            return Objects.hash(this.runDuration, this.timeBetweenStarts, this.dataStreamStats);
        }

        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
            return Iterators.concat((Iterator[])new Iterator[]{Iterators.single((builder, params) -> {
                builder.startObject();
                if (this.runDuration != null) {
                    builder.field("last_run_duration_in_millis", this.runDuration);
                    if (builder.humanReadable()) {
                        builder.field("last_run_duration", TimeValue.timeValueMillis((long)this.runDuration).toHumanReadableString(2));
                    }
                }
                if (this.timeBetweenStarts != null) {
                    builder.field("time_between_starts_in_millis", this.timeBetweenStarts);
                    if (builder.humanReadable()) {
                        builder.field("time_between_starts", TimeValue.timeValueMillis((long)this.timeBetweenStarts).toHumanReadableString(2));
                    }
                }
                builder.field("data_stream_count", this.dataStreamStats.size());
                builder.startArray("data_streams");
                return builder;
            }), Iterators.map(this.dataStreamStats.iterator(), stat -> (builder, params) -> {
                builder.startObject();
                builder.field("name", stat.dataStreamName);
                builder.field("backing_indices_in_total", stat.backingIndicesInTotal);
                builder.field("backing_indices_in_error", stat.backingIndicesInError);
                builder.endObject();
                return builder;
            }), Iterators.single((builder, params) -> {
                builder.endArray();
                builder.endObject();
                return builder;
            })});
        }

        public record DataStreamStats(String dataStreamName, int backingIndicesInTotal, int backingIndicesInError) implements Writeable
        {
            public static DataStreamStats read(StreamInput in) throws IOException {
                return new DataStreamStats(in.readString(), in.readVInt(), in.readVInt());
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.dataStreamName);
                out.writeVInt(this.backingIndicesInTotal);
                out.writeVInt(this.backingIndicesInError);
            }
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        public Request(StreamInput in) throws IOException {
            super(in);
        }

        public Request(TimeValue masterNodeTimeout) {
            super(masterNodeTimeout);
        }

        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

