/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.datastreams.ModifyDataStreamsAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeProjectAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataDataStreamsService;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportModifyDataStreamsAction
extends AcknowledgedTransportMasterNodeProjectAction<ModifyDataStreamsAction.Request> {
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final MetadataDataStreamsService metadataDataStreamsService;

    @Inject
    public TransportModifyDataStreamsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver, MetadataDataStreamsService metadataDataStreamsService) {
        super("indices:admin/data_stream/modify", transportService, clusterService, threadPool, actionFilters, ModifyDataStreamsAction.Request::new, projectResolver, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.metadataDataStreamsService = metadataDataStreamsService;
    }

    protected void masterOperation(Task task, ModifyDataStreamsAction.Request request, ProjectState state, ActionListener<AcknowledgedResponse> listener) {
        this.metadataDataStreamsService.modifyDataStream(state.projectId(), request, listener);
    }

    protected ClusterBlockException checkBlock(ModifyDataStreamsAction.Request request, ProjectState state) {
        ClusterBlockException globalBlock = state.blocks().globalBlockedException(state.projectId(), ClusterBlockLevel.METADATA_WRITE);
        if (globalBlock != null) {
            return globalBlock;
        }
        return state.blocks().indicesBlockedException(state.projectId(), ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state.metadata(), (IndicesRequest)request));
    }
}

