/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.exponentialhistogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.exponentialhistogram.BucketIterator;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramUtils;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramXContent;
import org.elasticsearch.exponentialhistogram.ZeroBucket;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.CompositeSyntheticFieldLoader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IgnoreMalformedStoredValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.CopyingXContentParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentSubParser;
import org.elasticsearch.xpack.exponentialhistogram.CompressedExponentialHistogram;
import org.elasticsearch.xpack.exponentialhistogram.IndexWithCount;

public class ExponentialHistogramFieldMapper
extends FieldMapper {
    public static final FeatureFlag EXPONENTIAL_HISTOGRAM_FEATURE = new FeatureFlag("exponential_histogram");
    public static final String CONTENT_TYPE = "exponential_histogram";
    public static final ParseField SCALE_FIELD = new ParseField("scale", new String[0]);
    public static final ParseField SUM_FIELD = new ParseField("sum", new String[0]);
    public static final ParseField MIN_FIELD = new ParseField("min", new String[0]);
    public static final ParseField MAX_FIELD = new ParseField("max", new String[0]);
    public static final ParseField ZERO_FIELD = new ParseField("zero", new String[0]);
    public static final ParseField ZERO_COUNT_FIELD = new ParseField("count", new String[0]);
    public static final ParseField ZERO_THRESHOLD_FIELD = new ParseField("threshold", new String[0]);
    public static final ParseField POSITIVE_FIELD = new ParseField("positive", new String[0]);
    public static final ParseField NEGATIVE_FIELD = new ParseField("negative", new String[0]);
    public static final ParseField BUCKET_INDICES_FIELD = new ParseField("indices", new String[0]);
    public static final ParseField BUCKET_COUNTS_FIELD = new ParseField("counts", new String[0]);
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings())), ExponentialHistogramFieldMapper.notInMultiFields((String)"exponential_histogram"));
    private final Explicit<Boolean> ignoreMalformed;
    private final boolean ignoreMalformedByDefault;

    private static ExponentialHistogramFieldMapper toType(FieldMapper in) {
        return (ExponentialHistogramFieldMapper)in;
    }

    private static String zeroThresholdSubFieldName(String fullPath) {
        return fullPath + "._zero_threshold";
    }

    private static String valuesCountSubFieldName(String fullPath) {
        return fullPath + "._values_count";
    }

    private static String valuesSumSubFieldName(String fullPath) {
        return fullPath + "._values_sum";
    }

    private static String valuesMinSubFieldName(String fullPath) {
        return fullPath + "._values_min";
    }

    private static String valuesMaxSubFieldName(String fullPath) {
        return fullPath + "._values_max";
    }

    ExponentialHistogramFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, Builder builder) {
        super(simpleName, mappedFieldType, builderParams);
        this.ignoreMalformed = (Explicit)builder.ignoreMalformed.getValue();
        this.ignoreMalformedByDefault = (Boolean)((Explicit)builder.ignoreMalformed.getDefaultValue()).value();
    }

    public boolean ignoreMalformed() {
        return (Boolean)this.ignoreMalformed.value();
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.ignoreMalformedByDefault).init(this);
    }

    protected void parseCreateField(DocumentParserContext context) {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    protected boolean supportsParsingObject() {
        return true;
    }

    public void parse(DocumentParserContext context) throws IOException {
        context.path().add(this.leafName());
        boolean shouldStoreMalformedDataForSyntheticSource = context.mappingLookup().isSourceSynthetic() && this.ignoreMalformed();
        XContentSubParser subParser = null;
        XContentBuilder malformedDataForSyntheticSource = null;
        try {
            long totalValueCount;
            XContentParser.Token token = context.parser().currentToken();
            if (token == XContentParser.Token.VALUE_NULL) {
                context.path().remove();
                return;
            }
            Double sum = null;
            Double min = null;
            Double max = null;
            Integer scale = null;
            ParsedZeroBucket zeroBucket = ParsedZeroBucket.DEFAULT;
            List<IndexWithCount> negativeBuckets = Collections.emptyList();
            List<IndexWithCount> positiveBuckets = Collections.emptyList();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)context.parser());
            if (shouldStoreMalformedDataForSyntheticSource) {
                CopyingXContentParser copyingParser = new CopyingXContentParser(context.parser());
                malformedDataForSyntheticSource = copyingParser.getBuilder();
                subParser = new XContentSubParser((XContentParser)copyingParser);
            } else {
                subParser = new XContentSubParser(context.parser());
            }
            token = subParser.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)subParser);
                String fieldName = subParser.currentName();
                if (fieldName.equals(SCALE_FIELD.getPreferredName())) {
                    token = subParser.nextToken();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)subParser);
                    scale = subParser.intValue();
                    if (scale > 38 || scale < -11) {
                        throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], scale field must be in range [-11, 38] but got " + scale);
                    }
                } else if (fieldName.equals(SUM_FIELD.getPreferredName())) {
                    sum = this.parseDoubleAllowingInfinity((XContentParser)subParser);
                } else if (fieldName.equals(MIN_FIELD.getPreferredName())) {
                    min = this.parseDoubleAllowingInfinity((XContentParser)subParser);
                } else if (fieldName.equals(MAX_FIELD.getPreferredName())) {
                    max = this.parseDoubleAllowingInfinity((XContentParser)subParser);
                } else if (fieldName.equals(ZERO_FIELD.getPreferredName())) {
                    zeroBucket = this.parseZeroBucket(subParser);
                } else if (fieldName.equals(POSITIVE_FIELD.getPreferredName())) {
                    positiveBuckets = this.readAndValidateBuckets(POSITIVE_FIELD.getPreferredName(), subParser);
                } else if (fieldName.equals(NEGATIVE_FIELD.getPreferredName())) {
                    negativeBuckets = this.readAndValidateBuckets(NEGATIVE_FIELD.getPreferredName(), subParser);
                } else {
                    throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], with unknown parameter [" + fieldName + "]");
                }
                token = subParser.nextToken();
            }
            if (scale == null) {
                throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], expected field called [" + SCALE_FIELD.getPreferredName() + "]");
            }
            if (context.doc().getByKey((Object)this.fieldType().name()) != null) {
                throw new IllegalArgumentException("Field [" + this.fullPath() + "] of type [" + this.typeName() + "] doesn't support indexing multiple values for the same field in the same document");
            }
            try {
                totalValueCount = ExponentialHistogramFieldMapper.getTotalValueCount(zeroBucket, positiveBuckets, negativeBuckets);
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("Field [" + this.fullPath() + "] has a total value count exceeding the allowed maximum value of 9223372036854775807");
            }
            sum = this.validateOrEstimateSum(sum, scale, negativeBuckets, positiveBuckets, totalValueCount, subParser);
            min = this.validateOrEstimateMin(min, zeroBucket, scale, negativeBuckets, positiveBuckets, totalValueCount, subParser);
            max = this.validateOrEstimateMax(max, zeroBucket, scale, negativeBuckets, positiveBuckets, totalValueCount, subParser);
            BytesStreamOutput histogramBytesOutput = new BytesStreamOutput();
            CompressedExponentialHistogram.writeHistogramBytes((StreamOutput)histogramBytesOutput, scale, negativeBuckets, positiveBuckets);
            BytesRef histoBytes = histogramBytesOutput.bytes().toBytesRef();
            BinaryDocValuesField histoField = new BinaryDocValuesField(this.fullPath(), histoBytes);
            long thresholdAsLong = NumericUtils.doubleToSortableLong((double)zeroBucket.threshold());
            NumericDocValuesField zeroThresholdField = new NumericDocValuesField(ExponentialHistogramFieldMapper.zeroThresholdSubFieldName(this.fullPath()), thresholdAsLong);
            NumericDocValuesField valuesCountField = new NumericDocValuesField(ExponentialHistogramFieldMapper.valuesCountSubFieldName(this.fullPath()), totalValueCount);
            NumericDocValuesField sumField = new NumericDocValuesField(ExponentialHistogramFieldMapper.valuesSumSubFieldName(this.fullPath()), NumericUtils.doubleToSortableLong((double)sum));
            context.doc().addWithKey((Object)this.fieldType().name(), (IndexableField)histoField);
            context.doc().add((IndexableField)zeroThresholdField);
            context.doc().add((IndexableField)valuesCountField);
            context.doc().add((IndexableField)sumField);
            if (min != null) {
                NumericDocValuesField minField = new NumericDocValuesField(ExponentialHistogramFieldMapper.valuesMinSubFieldName(this.fullPath()), NumericUtils.doubleToSortableLong((double)min));
                context.doc().add((IndexableField)minField);
            }
            if (max != null) {
                NumericDocValuesField maxField = new NumericDocValuesField(ExponentialHistogramFieldMapper.valuesMaxSubFieldName(this.fullPath()), NumericUtils.doubleToSortableLong((double)max));
                context.doc().add((IndexableField)maxField);
            }
        }
        catch (Exception ex) {
            if (!((Boolean)this.ignoreMalformed.value()).booleanValue()) {
                throw new DocumentParsingException(context.parser().getTokenLocation(), "failed to parse field [" + this.fieldType().name() + "] of type [" + this.fieldType().typeName() + "]", ex);
            }
            if (subParser != null) {
                subParser.close();
            } else if (shouldStoreMalformedDataForSyntheticSource) {
                malformedDataForSyntheticSource = XContentBuilder.builder((XContent)context.parser().contentType().xContent()).copyCurrentStructure(context.parser());
            }
            if (malformedDataForSyntheticSource != null) {
                context.doc().add((IndexableField)IgnoreMalformedStoredValues.storedField((String)this.fullPath(), malformedDataForSyntheticSource));
            }
            context.addIgnoredField(this.fieldType().name());
        }
        context.path().remove();
    }

    private Double validateOrEstimateSum(Double sum, Integer scale, List<IndexWithCount> negativeBuckets, List<IndexWithCount> positiveBuckets, long totalValueCount, XContentSubParser subParser) {
        if (sum == null) {
            return ExponentialHistogramUtils.estimateSum((BucketIterator)IndexWithCount.asBuckets(scale, negativeBuckets).iterator(), (BucketIterator)IndexWithCount.asBuckets(scale, positiveBuckets).iterator());
        }
        if (totalValueCount == 0L && sum != 0.0) {
            throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], sum field must be zero if the histogram is empty, but got " + sum);
        }
        return sum;
    }

    private Double validateOrEstimateMin(Double parsedMin, ParsedZeroBucket zeroBucket, Integer scale, List<IndexWithCount> negativeBuckets, List<IndexWithCount> positiveBuckets, long totalValueCount, XContentSubParser subParser) {
        if (parsedMin == null) {
            OptionalDouble estimatedMin = ExponentialHistogramUtils.estimateMin((ZeroBucket)ZeroBucket.create((double)zeroBucket.threshold(), (long)zeroBucket.count), (ExponentialHistogram.Buckets)IndexWithCount.asBuckets(scale, negativeBuckets), (ExponentialHistogram.Buckets)IndexWithCount.asBuckets(scale, positiveBuckets));
            return estimatedMin.isPresent() ? Double.valueOf(estimatedMin.getAsDouble()) : null;
        }
        if (totalValueCount == 0L) {
            throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], min field must be null if the histogram is empty, but got " + parsedMin);
        }
        return parsedMin;
    }

    private Double validateOrEstimateMax(Double parsedMax, ParsedZeroBucket zeroBucket, Integer scale, List<IndexWithCount> negativeBuckets, List<IndexWithCount> positiveBuckets, long totalValueCount, XContentSubParser subParser) {
        if (parsedMax == null) {
            OptionalDouble estimatedMax = ExponentialHistogramUtils.estimateMax((ZeroBucket)ZeroBucket.create((double)zeroBucket.threshold(), (long)zeroBucket.count), (ExponentialHistogram.Buckets)IndexWithCount.asBuckets(scale, negativeBuckets), (ExponentialHistogram.Buckets)IndexWithCount.asBuckets(scale, positiveBuckets));
            return estimatedMax.isPresent() ? Double.valueOf(estimatedMax.getAsDouble()) : null;
        }
        if (totalValueCount == 0L) {
            throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], max field must be null if the histogram is empty, but got " + parsedMax);
        }
        return parsedMax;
    }

    private double parseDoubleAllowingInfinity(XContentParser parser) throws IOException {
        String text;
        boolean isValidNumber;
        XContentParser.Token token = parser.nextToken();
        boolean bl = isValidNumber = token == XContentParser.Token.VALUE_NUMBER;
        if (token == XContentParser.Token.VALUE_STRING && ((text = parser.text()).equals("-Infinity") || text.equals("Infinity"))) {
            isValidNumber = true;
        }
        if (isValidNumber) {
            return parser.doubleValue();
        }
        throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], expected a number but got " + String.valueOf(token));
    }

    private static long getTotalValueCount(ParsedZeroBucket zeroBucket, List<IndexWithCount> positiveBuckets, List<IndexWithCount> negativeBuckets) {
        long totalValueCount = zeroBucket.count();
        for (IndexWithCount bucket : positiveBuckets) {
            totalValueCount = Math.addExact(totalValueCount, bucket.count());
        }
        for (IndexWithCount bucket : negativeBuckets) {
            totalValueCount = Math.addExact(totalValueCount, bucket.count());
        }
        return totalValueCount;
    }

    private ParsedZeroBucket parseZeroBucket(XContentSubParser subParser) throws IOException {
        long zeroCount = ParsedZeroBucket.DEFAULT.count();
        double zeroThreshold = ParsedZeroBucket.DEFAULT.threshold();
        XContentParser.Token token = subParser.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)subParser);
        token = subParser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)subParser);
            String fieldName = subParser.currentName();
            if (fieldName.equals(ZERO_THRESHOLD_FIELD.getPreferredName())) {
                token = subParser.nextToken();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)subParser);
                zeroThreshold = subParser.doubleValue();
                if (zeroThreshold < 0.0 || !Double.isFinite(zeroThreshold)) {
                    throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], zero.threshold field must be a non-negative, finite number but got " + zeroThreshold);
                }
            } else if (fieldName.equals(ZERO_COUNT_FIELD.getPreferredName())) {
                token = subParser.nextToken();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)subParser);
                zeroCount = subParser.longValue();
                if (zeroCount < 0L) {
                    throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], zero.count field must be a non-negative number but got " + zeroCount);
                }
            } else {
                throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], with unknown parameter for zero sub-object [" + fieldName + "]");
            }
            token = subParser.nextToken();
        }
        return new ParsedZeroBucket(zeroCount, zeroThreshold);
    }

    private List<IndexWithCount> readAndValidateBuckets(String containerFieldName, XContentSubParser parser) throws IOException {
        int i;
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        token = parser.nextToken();
        List indices = Collections.emptyList();
        List counts = Collections.emptyList();
        while (token != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
            String fieldName = parser.currentName();
            if (fieldName.equals(BUCKET_INDICES_FIELD.getPreferredName())) {
                indices = new ArrayList();
                token = parser.nextToken();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)token, (XContentParser)parser);
                token = parser.nextToken();
                while (token != XContentParser.Token.END_ARRAY) {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)parser);
                    long index = parser.longValue();
                    if (index < -4611686018427387903L || index > 0x3FFFFFFFFFFFFFFFL) {
                        throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], " + containerFieldName + "." + BUCKET_INDICES_FIELD.getPreferredName() + " values must all be in range [-4611686018427387903, 4611686018427387903] but got " + index);
                    }
                    indices.add(index);
                    token = parser.nextToken();
                }
            } else if (fieldName.equals(BUCKET_COUNTS_FIELD.getPreferredName())) {
                counts = new ArrayList();
                token = parser.nextToken();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)token, (XContentParser)parser);
                token = parser.nextToken();
                while (token != XContentParser.Token.END_ARRAY) {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)parser);
                    long count = parser.longValue();
                    if (count <= 0L) {
                        throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], " + containerFieldName + "." + BUCKET_COUNTS_FIELD.getPreferredName() + " values must all be greater than zero but got " + count);
                    }
                    counts.add(count);
                    token = parser.nextToken();
                }
            } else {
                throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], with unknown parameter for " + containerFieldName + " sub-object [" + fieldName + "]");
            }
            token = parser.nextToken();
        }
        if (indices.size() != counts.size()) {
            throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], expected same length from [" + containerFieldName + "." + BUCKET_INDICES_FIELD.getPreferredName() + "] and [" + containerFieldName + "." + BUCKET_COUNTS_FIELD.getPreferredName() + "] but got [" + indices.size() + " != " + counts.size() + "]");
        }
        ArrayList<IndexWithCount> results = new ArrayList<IndexWithCount>(indices.size());
        for (i = 0; i < indices.size(); ++i) {
            results.add(new IndexWithCount((Long)indices.get(i), (Long)counts.get(i)));
        }
        results.sort(Comparator.comparing(IndexWithCount::index));
        for (i = 1; i < results.size(); ++i) {
            long index = ((IndexWithCount)results.get(i)).index();
            if (index != ((IndexWithCount)results.get(i - 1)).index()) continue;
            throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], expected entries of [" + containerFieldName + "." + BUCKET_INDICES_FIELD.getPreferredName() + "] to be unique, but got " + index + " multiple times");
        }
        return results;
    }

    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        return new FieldMapper.SyntheticSourceSupport.Native(() -> new CompositeSyntheticFieldLoader(this.leafName(), this.fullPath(), new CompositeSyntheticFieldLoader.Layer[]{new ExponentialHistogramSyntheticFieldLoader(), new CompositeSyntheticFieldLoader.MalformedValuesLayer(this.fullPath())}));
    }

    static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;

        Builder(String name, boolean ignoreMalformedByDefault) {
            super(name);
            this.ignoreMalformed = FieldMapper.Parameter.explicitBoolParam((String)"ignore_malformed", (boolean)true, m -> ExponentialHistogramFieldMapper.toType((FieldMapper)m).ignoreMalformed, (boolean)ignoreMalformedByDefault);
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.ignoreMalformed, this.meta};
        }

        public ExponentialHistogramFieldMapper build(MapperBuilderContext context) {
            return new ExponentialHistogramFieldMapper(this.leafName(), new ExponentialHistogramFieldType(context.buildFullName(this.leafName()), (Map)this.meta.getValue()), this.builderParams((Mapper.Builder)this, context), this);
        }
    }

    private record ParsedZeroBucket(long count, double threshold) {
        static final ParsedZeroBucket DEFAULT = new ParsedZeroBucket(0L, 0.0);
    }

    private class ExponentialHistogramSyntheticFieldLoader
    implements CompositeSyntheticFieldLoader.DocValuesLayer {
        private final CompressedExponentialHistogram histogram = new CompressedExponentialHistogram();
        private BytesRef binaryValue;
        private double zeroThreshold;
        private long valueCount;
        private double valueSum;
        private double valueMin;
        private double valueMax;

        private ExponentialHistogramSyntheticFieldLoader() {
        }

        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            BinaryDocValues histoDocValues = leafReader.getBinaryDocValues(ExponentialHistogramFieldMapper.this.fieldType().name());
            if (histoDocValues == null) {
                this.binaryValue = null;
                return null;
            }
            NumericDocValues zeroThresholds = leafReader.getNumericDocValues(ExponentialHistogramFieldMapper.zeroThresholdSubFieldName(ExponentialHistogramFieldMapper.this.fullPath()));
            NumericDocValues valueCounts = leafReader.getNumericDocValues(ExponentialHistogramFieldMapper.valuesCountSubFieldName(ExponentialHistogramFieldMapper.this.fullPath()));
            NumericDocValues valueSums = leafReader.getNumericDocValues(ExponentialHistogramFieldMapper.valuesSumSubFieldName(ExponentialHistogramFieldMapper.this.fullPath()));
            NumericDocValues valueMinima = leafReader.getNumericDocValues(ExponentialHistogramFieldMapper.valuesMinSubFieldName(ExponentialHistogramFieldMapper.this.fullPath()));
            NumericDocValues valueMaxima = leafReader.getNumericDocValues(ExponentialHistogramFieldMapper.valuesMaxSubFieldName(ExponentialHistogramFieldMapper.this.fullPath()));
            assert (zeroThresholds != null);
            assert (valueCounts != null);
            assert (valueSums != null);
            return docId -> {
                if (histoDocValues.advanceExact(docId)) {
                    boolean zeroThresholdPresent = zeroThresholds.advanceExact(docId);
                    boolean valueCountsPresent = valueCounts.advanceExact(docId);
                    boolean valueSumsPresent = valueSums.advanceExact(docId);
                    assert (zeroThresholdPresent && valueCountsPresent && valueSumsPresent);
                    this.binaryValue = histoDocValues.binaryValue();
                    this.zeroThreshold = NumericUtils.sortableLongToDouble((long)zeroThresholds.longValue());
                    this.valueCount = valueCounts.longValue();
                    this.valueSum = NumericUtils.sortableLongToDouble((long)valueSums.longValue());
                    this.valueMin = valueMinima != null && valueMinima.advanceExact(docId) ? NumericUtils.sortableLongToDouble((long)valueMinima.longValue()) : Double.NaN;
                    this.valueMax = valueMaxima != null && valueMaxima.advanceExact(docId) ? NumericUtils.sortableLongToDouble((long)valueMaxima.longValue()) : Double.NaN;
                    return true;
                }
                this.binaryValue = null;
                return false;
            };
        }

        public boolean hasValue() {
            return this.binaryValue != null;
        }

        public void write(XContentBuilder b) throws IOException {
            if (this.binaryValue == null) {
                return;
            }
            this.histogram.reset(this.zeroThreshold, this.valueCount, this.valueSum, this.valueMin, this.valueMax, this.binaryValue);
            ExponentialHistogramXContent.serialize((XContentBuilder)b, (ExponentialHistogram)this.histogram);
        }

        public String fieldName() {
            return ExponentialHistogramFieldMapper.this.fullPath();
        }

        public long valueCount() {
            return this.binaryValue != null ? 1L : 0L;
        }
    }

    static class ExponentialHistogramFieldType
    extends MappedFieldType {
        ExponentialHistogramFieldType(String name, Map<String, String> meta) {
            super(name, false, false, true, meta);
        }

        public String typeName() {
            return ExponentialHistogramFieldMapper.CONTENT_TYPE;
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.identity((String)this.name(), (SearchExecutionContext)context, (String)format);
        }

        public boolean isAggregatable() {
            return false;
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            throw new IllegalArgumentException("The [exponential_histogram] field does not support this operation currently");
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("[exponential_histogram] field do not support searching, use dedicated aggregations instead: [" + this.name() + "]");
        }
    }
}

