/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.validation;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.action.support.MappedActionFilter;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.tasks.Task;

public abstract class DotPrefixValidator<RequestType>
implements MappedActionFilter {
    public static final Setting<Boolean> VALIDATE_DOT_PREFIXES = Setting.boolSetting((String)"cluster.indices.validate_dot_prefixes", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static Set<String> IGNORED_INDEX_NAMES = Set.of(".elastic-connectors-v1", ".elastic-connectors-sync-jobs-v1", ".ml-state");
    public static final Setting<List<String>> IGNORED_INDEX_PATTERNS_SETTING = Setting.stringListSetting((String)"cluster.indices.validate_ignored_dot_patterns", List.of("\\.ml-anomalies-.*", "\\.ml-annotations-\\d+", "\\.ml-state-\\d+", "\\.ml-stats-\\d+", "\\.slo-observability\\.sli-v\\d+.*", "\\.slo-observability\\.summary-v\\d+.*", "\\.entities\\.v\\d+\\..*", "\\.monitoring-es-8-.*", "\\.monitoring-logstash-8-.*", "\\.monitoring-kibana-8-.*", "\\.monitoring-beats-8-.*", "\\.monitoring-ent-search-8-.*"), patternList -> patternList.forEach(pattern -> {
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("invalid dot validation exception pattern: [" + pattern + "]", e);
        }
    }), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(DotPrefixValidator.class);
    private final ThreadContext threadContext;
    private final boolean isEnabled;
    private volatile Set<Pattern> ignoredIndexPatterns;

    public DotPrefixValidator(ThreadContext threadContext, ClusterService clusterService) {
        this.threadContext = threadContext;
        this.isEnabled = (Boolean)VALIDATE_DOT_PREFIXES.get(clusterService.getSettings());
        this.ignoredIndexPatterns = ((List)IGNORED_INDEX_PATTERNS_SETTING.get(clusterService.getSettings())).stream().map(Pattern::compile).collect(Collectors.toSet());
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IGNORED_INDEX_PATTERNS_SETTING, this::updateIgnoredIndexPatterns);
    }

    private void updateIgnoredIndexPatterns(List<String> patterns) {
        this.ignoredIndexPatterns = patterns.stream().map(Pattern::compile).collect(Collectors.toSet());
    }

    protected abstract Set<String> getIndicesFromRequest(RequestType var1);

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        Set<String> indices = this.getIndicesFromRequest(request);
        if (this.isEnabled) {
            this.validateIndices(indices);
        }
        chain.proceed(task, action, request, listener);
    }

    void validateIndices(@Nullable Set<String> indices) {
        if (indices != null && !this.isInternalRequest()) {
            for (String index : indices) {
                char c;
                if (!Strings.hasLength((String)index) || (c = DotPrefixValidator.getFirstChar(index)) != '.') continue;
                String strippedName = DotPrefixValidator.stripDateMath(index);
                if (IGNORED_INDEX_NAMES.contains(strippedName)) {
                    return;
                }
                if (this.ignoredIndexPatterns.stream().anyMatch(p -> p.matcher(strippedName).matches())) {
                    return;
                }
                this.deprecationLogger.warn(DeprecationCategory.INDICES, "dot-prefix", "Index [{}] name begins with a dot (.), which is deprecated, and will not be allowed in a future Elasticsearch version.", new Object[]{index});
            }
        }
    }

    private static char getFirstChar(String index) {
        String strippedLeading;
        char c = index.charAt(0);
        if (c == '<' && Strings.hasLength((String)(strippedLeading = index.substring(1)))) {
            c = strippedLeading.charAt(0);
        }
        return c;
    }

    private static String stripDateMath(String index) {
        char c = index.charAt(0);
        if (c == '<') {
            assert (index.charAt(index.length() - 1) == '>') : "expected index name with date math to start with < and end with >, how did this pass request validation? " + index;
            return index.substring(1, index.length() - 1);
        }
        return index;
    }

    boolean isInternalRequest() {
        String actionOrigin = (String)this.threadContext.getTransient("action.origin");
        boolean isSystemContext = this.threadContext.isSystemContext();
        boolean isInternalOrigin = Optional.ofNullable(actionOrigin).map(Strings::hasText).orElse(false);
        boolean hasElasticOriginHeader = Optional.ofNullable(this.threadContext.getHeader("X-elastic-product-origin")).map(Strings::hasText).orElse(false);
        return isSystemContext || isInternalOrigin || hasElasticOriginHeader;
    }
}

