/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.support.ValuesSource;

class HistogramValuesSource
extends ValuesSource.Numeric {
    private final ValuesSource.Numeric vs;
    private final double interval;

    HistogramValuesSource(ValuesSource.Numeric vs, double interval) {
        this.vs = vs;
        this.interval = interval;
    }

    @Override
    public boolean isFloatingPoint() {
        return true;
    }

    @Override
    public SortedNumericDoubleValues doubleValues(LeafReaderContext context) throws IOException {
        SortedNumericDoubleValues values = this.vs.doubleValues(context);
        NumericDoubleValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            return FieldData.singleton(this.doubleSingleValues(singleton));
        }
        return this.doubleMultiValues(values);
    }

    private SortedNumericDoubleValues doubleMultiValues(final SortedNumericDoubleValues values) {
        return new SortedNumericDoubleValues(){

            @Override
            public double nextValue() throws IOException {
                return Math.floor(values.nextValue() / HistogramValuesSource.this.interval) * HistogramValuesSource.this.interval;
            }

            @Override
            public int docValueCount() {
                return values.docValueCount();
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                return values.advanceExact(target);
            }
        };
    }

    private NumericDoubleValues doubleSingleValues(final NumericDoubleValues values) {
        return new NumericDoubleValues(){

            public double doubleValue() throws IOException {
                return Math.floor(values.doubleValue() / HistogramValuesSource.this.interval) * HistogramValuesSource.this.interval;
            }

            public boolean advanceExact(int target) throws IOException {
                return values.advanceExact(target);
            }
        };
    }

    @Override
    public SortedBinaryDocValues bytesValues(LeafReaderContext context) throws IOException {
        throw new UnsupportedOperationException("not applicable");
    }

    @Override
    public SortedNumericDocValues longValues(LeafReaderContext context) throws IOException {
        throw new UnsupportedOperationException("not applicable");
    }
}

