/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reservedstate.service;

import java.io.IOException;
import java.util.Collection;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.reservedstate.ReservedClusterStateHandler;
import org.elasticsearch.reservedstate.ReservedProjectStateHandler;
import org.elasticsearch.reservedstate.TransformState;
import org.elasticsearch.xcontent.XContentParser;

class ProjectClusterStateHandlerAdapter<T>
implements ReservedClusterStateHandler<T> {
    private final ProjectId projectId;
    private final ReservedProjectStateHandler<T> handler;

    ProjectClusterStateHandlerAdapter(ProjectId projectId, ReservedProjectStateHandler<T> handler) {
        this.projectId = projectId;
        this.handler = handler;
    }

    @Override
    public String name() {
        return this.handler.name();
    }

    @Override
    public Collection<String> dependencies() {
        return this.handler.dependencies();
    }

    @Override
    public Collection<String> optionalDependencies() {
        return this.handler.optionalDependencies();
    }

    @Override
    public void validate(MasterNodeRequest<?> request) {
        this.handler.validate(request);
    }

    @Override
    public T fromXContent(XContentParser parser) throws IOException {
        return this.handler.fromXContent(parser);
    }

    @Override
    public TransformState transform(T source, TransformState prevState) throws Exception {
        return this.handler.transform(this.projectId, source, prevState);
    }

    @Override
    public ClusterState remove(TransformState prevState) throws Exception {
        return this.handler.remove(this.projectId, prevState);
    }

    public String toString() {
        return "ProjectClusterStateHandlerAdapter[" + this.handler.toString() + "]";
    }
}

