/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public record StatusInfo(Status status, String info) implements Writeable
{
    public StatusInfo(StreamInput in) throws IOException {
        this(StatusInfo.readStatus(in), in.readString());
    }

    public String getInfo() {
        return this.info;
    }

    public Status getStatus() {
        return this.status;
    }

    private static Status readStatus(StreamInput in) throws IOException {
        String statusString = in.readString();
        return Status.valueOf(statusString);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.status == null ? null : this.status.name());
        out.writeString(this.info);
    }

    @Override
    public String toString() {
        return "status[" + String.valueOf((Object)this.status) + "], info[" + this.info + "]";
    }

    public static enum Status {
        HEALTHY,
        UNHEALTHY;

    }
}

