/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference;

import java.io.Closeable;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.ChunkInferenceInput;
import org.elasticsearch.inference.ChunkedInference;
import org.elasticsearch.inference.InferenceServiceConfiguration;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.inference.MinimalServiceSettings;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.inference.validation.ServiceIntegrationValidator;

public interface InferenceService
extends Closeable {
    public String name();

    default public List<String> aliases() {
        return List.of();
    }

    public void parseRequestConfig(String var1, TaskType var2, Map<String, Object> var3, ActionListener<Model> var4);

    public Model parsePersistedConfigWithSecrets(String var1, TaskType var2, Map<String, Object> var3, Map<String, Object> var4);

    public Model parsePersistedConfig(String var1, TaskType var2, Map<String, Object> var3);

    public InferenceServiceConfiguration getConfiguration();

    default public boolean hideFromConfigurationApi() {
        return false;
    }

    public EnumSet<TaskType> supportedTaskTypes();

    public void infer(Model var1, @Nullable String var2, @Nullable Boolean var3, @Nullable Integer var4, List<String> var5, boolean var6, Map<String, Object> var7, InputType var8, @Nullable TimeValue var9, ActionListener<InferenceServiceResults> var10);

    public void unifiedCompletionInfer(Model var1, UnifiedCompletionRequest var2, TimeValue var3, ActionListener<InferenceServiceResults> var4);

    public void chunkedInfer(Model var1, @Nullable String var2, List<ChunkInferenceInput> var3, Map<String, Object> var4, InputType var5, TimeValue var6, ActionListener<List<ChunkedInference>> var7);

    public void start(Model var1, TimeValue var2, ActionListener<Boolean> var3);

    default public void stop(Model model, ActionListener<Boolean> listener) {
        listener.onResponse(true);
    }

    default public Model updateModelWithEmbeddingDetails(Model model, int embeddingSize) {
        return model;
    }

    default public Model updateModelWithChatCompletionDetails(Model model) {
        return model;
    }

    public TransportVersion getMinimalSupportedVersion();

    default public Set<TaskType> supportedStreamingTasks() {
        return Set.of();
    }

    default public boolean canStream(TaskType taskType) {
        return this.supportedStreamingTasks().contains(taskType);
    }

    default public List<DefaultConfigId> defaultConfigIds() {
        return List.of();
    }

    default public void defaultConfigs(ActionListener<List<Model>> defaultsListener) {
        defaultsListener.onResponse(List.of());
    }

    default public void updateModelsWithDynamicFields(List<Model> model, ActionListener<List<Model>> listener) {
        listener.onResponse(model);
    }

    default public void onNodeStarted() {
    }

    default public ServiceIntegrationValidator getServiceIntegrationValidator(TaskType taskType) {
        return null;
    }

    public record DefaultConfigId(String inferenceId, MinimalServiceSettings settings, InferenceService service) {
    }
}

