/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.usage.NodeUsageStatsForThreadPoolsAction;
import org.elasticsearch.action.admin.cluster.node.usage.TransportNodeUsageStatsForThreadPoolsAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NodeUsageStatsForThreadPools;
import org.elasticsearch.cluster.node.DiscoveryNode;

public class NodeUsageStatsForThreadPoolsCollector {
    public static final NodeUsageStatsForThreadPoolsCollector EMPTY = new NodeUsageStatsForThreadPoolsCollector(){

        @Override
        public void collectUsageStats(Client client, ClusterState clusterState, ActionListener<Map<String, NodeUsageStatsForThreadPools>> listener) {
            listener.onResponse(Map.of());
        }
    };
    private static final TransportVersion TRANSPORT_NODE_USAGE_STATS_FOR_THREAD_POOLS_ACTION = TransportVersion.fromName("transport_node_usage_stats_for_thread_pools_action");
    private static final Logger logger = LogManager.getLogger(NodeUsageStatsForThreadPoolsCollector.class);
    private final Map<String, NodeUsageStatsForThreadPools> lastNodeUsageStatsPerNode = new ConcurrentHashMap<String, NodeUsageStatsForThreadPools>();

    public void collectUsageStats(Client client, ClusterState clusterState, ActionListener<Map<String, NodeUsageStatsForThreadPools>> listener) {
        String[] dataNodeIds = (String[])clusterState.nodes().getDataNodes().values().stream().map(DiscoveryNode::getId).toArray(String[]::new);
        this.lastNodeUsageStatsPerNode.keySet().retainAll(Arrays.asList(dataNodeIds));
        if (clusterState.getMinTransportVersion().supports(TRANSPORT_NODE_USAGE_STATS_FOR_THREAD_POOLS_ACTION)) {
            client.execute(TransportNodeUsageStatsForThreadPoolsAction.TYPE, new NodeUsageStatsForThreadPoolsAction.Request(dataNodeIds), listener.map(response -> {
                this.lastNodeUsageStatsPerNode.putAll(response.getAllNodeUsageStatsForThreadPools());
                if (!response.failures().isEmpty()) {
                    logger.warn("Got no usage stats from nodes [{}], using last known stats for them", (Object)response.failures().stream().map(FailedNodeException::nodeId).collect(Collectors.joining(", ")));
                }
                return Map.copyOf(this.lastNodeUsageStatsPerNode);
            }));
        } else {
            listener.onResponse(Map.of());
        }
    }
}

