/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.post;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.admin.indices.template.put.TransportPutComposableIndexTemplateAction;
import org.elasticsearch.action.support.local.LocalClusterStateRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class SimulateIndexTemplateRequest
extends LocalClusterStateRequest {
    private String indexName;
    @Nullable
    private TransportPutComposableIndexTemplateAction.Request indexTemplateRequest;
    private boolean includeDefaults = false;

    public SimulateIndexTemplateRequest(TimeValue masterTimeout, String indexName) {
        super(masterTimeout);
        if (Strings.isNullOrEmpty(indexName)) {
            throw new IllegalArgumentException("index name cannot be null or empty");
        }
        this.indexName = indexName;
    }

    public SimulateIndexTemplateRequest(StreamInput in) throws IOException {
        super(in);
        this.indexName = in.readString();
        this.indexTemplateRequest = in.readOptionalWriteable(TransportPutComposableIndexTemplateAction.Request::new);
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            this.includeDefaults = in.readBoolean();
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indexTemplateRequest != null) {
            validationException = this.indexTemplateRequest.validateIndexTemplate(validationException);
        }
        return validationException;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, "", parentTaskId, headers);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public boolean includeDefaults() {
        return this.includeDefaults;
    }

    @Nullable
    public TransportPutComposableIndexTemplateAction.Request getIndexTemplateRequest() {
        return this.indexTemplateRequest;
    }

    public SimulateIndexTemplateRequest indexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public SimulateIndexTemplateRequest indexTemplateRequest(TransportPutComposableIndexTemplateAction.Request indexTemplateRequest) {
        this.indexTemplateRequest = indexTemplateRequest;
        return this;
    }

    public SimulateIndexTemplateRequest includeDefaults(boolean includeDefaults) {
        this.includeDefaults = includeDefaults;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimulateIndexTemplateRequest that = (SimulateIndexTemplateRequest)o;
        return this.indexName.equals(that.indexName) && Objects.equals(this.indexTemplateRequest, that.indexTemplateRequest) && this.includeDefaults == that.includeDefaults;
    }

    public int hashCode() {
        return Objects.hash(this.indexName, this.indexTemplateRequest, this.includeDefaults);
    }
}

