/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.settings.get;

import java.util.Collections;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.local.TransportLocalProjectMetadataAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.Index;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;

public class TransportGetSettingsAction
extends TransportLocalProjectMetadataAction<GetSettingsRequest, GetSettingsResponse> {
    private final SettingsFilter settingsFilter;
    private final IndexScopedSettings indexScopedSettings;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportGetSettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SettingsFilter settingsFilter, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver, IndexScopedSettings indexedScopedSettings) {
        super("indices:monitor/settings/get", actionFilters, transportService.getTaskManager(), clusterService, threadPool.executor("management"), projectResolver);
        this.settingsFilter = settingsFilter;
        this.indexScopedSettings = indexedScopedSettings;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        transportService.registerRequestHandler(this.actionName, this.executor, false, true, GetSettingsRequest::new, (request, channel, task) -> this.executeDirect(task, request, new ChannelActionListener(channel)));
    }

    @Override
    protected ClusterBlockException checkBlock(GetSettingsRequest request, ProjectState state) {
        return state.blocks().indicesBlockedException(state.projectId(), ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state.metadata(), (IndicesRequest)request));
    }

    private static boolean isFilteredRequest(GetSettingsRequest request) {
        return !CollectionUtils.isEmpty(request.names());
    }

    @Override
    protected void localClusterStateOperation(Task task, GetSettingsRequest request, ProjectState state, ActionListener<GetSettingsResponse> listener) {
        assert (Transports.assertNotTransportThread("O(indices) work is too much for a transport thread"));
        Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(state.metadata(), (IndicesRequest)request);
        Map<String, Settings> indexToSettings = Maps.newHashMapWithExpectedSize(concreteIndices.length);
        Map<String, Settings> indexToDefaultSettings = request.includeDefaults() ? Maps.newHashMapWithExpectedSize(concreteIndices.length) : null;
        for (Index concreteIndex : concreteIndices) {
            IndexMetadata indexMetadata = state.metadata().index(concreteIndex);
            if (indexMetadata == null) continue;
            Settings indexSettings = this.settingsFilter.filter(indexMetadata.getSettings());
            if (request.humanReadable()) {
                indexSettings = IndexMetadata.addHumanReadableSettings(indexSettings);
            }
            if (TransportGetSettingsAction.isFilteredRequest(request)) {
                indexSettings = indexSettings.filter(k -> Regex.simpleMatch(request.names(), k));
            }
            indexToSettings.put(concreteIndex.getName(), indexSettings);
            if (indexToDefaultSettings == null) continue;
            Settings defaultSettings = this.settingsFilter.filter(this.indexScopedSettings.diff(indexMetadata.getSettings(), Settings.EMPTY));
            if (TransportGetSettingsAction.isFilteredRequest(request)) {
                defaultSettings = defaultSettings.filter(k -> Regex.simpleMatch(request.names(), k));
            }
            indexToDefaultSettings.put(concreteIndex.getName(), defaultSettings);
        }
        listener.onResponse(new GetSettingsResponse(Collections.unmodifiableMap(indexToSettings), indexToDefaultSettings == null ? Map.of() : Collections.unmodifiableMap(indexToDefaultSettings)));
    }
}

