/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.coordination;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.coordination.MasterHistoryService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class MasterHistoryAction
extends ActionType<Response> {
    public static final MasterHistoryAction INSTANCE = new MasterHistoryAction();
    public static final String NAME = "internal:cluster/master_history/get";

    private MasterHistoryAction() {
        super(NAME);
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final MasterHistoryService masterHistoryService;

        @Inject
        public TransportAction(TransportService transportService, ActionFilters actionFilters, MasterHistoryService masterHistoryService) {
            super(MasterHistoryAction.NAME, transportService, actionFilters, Request::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
            this.masterHistoryService = masterHistoryService;
        }

        @Override
        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            listener.onResponse(new Response(this.masterHistoryService.getLocalMasterHistory().getRawNodes()));
        }
    }

    public static class Response
    extends ActionResponse {
        private final List<DiscoveryNode> masterHistory;

        public Response(List<DiscoveryNode> masterHistory) {
            this.masterHistory = masterHistory;
        }

        public Response(StreamInput in) throws IOException {
            int mastersCount = in.readVInt();
            this.masterHistory = new ArrayList<DiscoveryNode>(mastersCount);
            for (int i = 0; i < mastersCount; ++i) {
                this.masterHistory.add(in.readOptionalWriteable(DiscoveryNode::new));
            }
        }

        public List<DiscoveryNode> getMasterHistory() {
            return this.masterHistory;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.masterHistory.size());
            for (DiscoveryNode master : this.masterHistory) {
                out.writeOptionalWriteable(master);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.masterHistory.equals(response.masterHistory);
        }

        public int hashCode() {
            return Objects.hash(this.masterHistory);
        }
    }

    public static class Request
    extends LegacyActionRequest {
        public Request() {
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 1;
        }
    }
}

