/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.action;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ilm.LifecycleOperationMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.OperationMode;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicy;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.slm.action.PutSnapshotLifecycleAction;
import org.elasticsearch.xpack.slm.SnapshotLifecycleService;

public class TransportPutSnapshotLifecycleAction
extends TransportMasterNodeAction<PutSnapshotLifecycleAction.Request, AcknowledgedResponse> {
    private static final Logger logger = LogManager.getLogger(TransportPutSnapshotLifecycleAction.class);

    @Inject
    public TransportPutSnapshotLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters) {
        super("cluster:admin/slm/put", transportService, clusterService, threadPool, actionFilters, PutSnapshotLifecycleAction.Request::new, AcknowledgedResponse::readFrom, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    protected void masterOperation(Task task, PutSnapshotLifecycleAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        SnapshotLifecycleService.validateRepositoryExists(request.getLifecycle().getRepository(), state);
        SnapshotLifecycleService.validateMinimumInterval(request.getLifecycle(), state);
        Map filteredHeaders = ClientHelper.getPersistableSafeSecurityHeaders((ThreadContext)this.threadPool.getThreadContext(), (ClusterState)state);
        LifecyclePolicy.validatePolicyName((String)request.getLifecycleId());
        this.submitUnbatchedTask("put-snapshot-lifecycle-" + request.getLifecycleId(), (ClusterStateUpdateTask)new UpdateSnapshotPolicyTask(request, listener, filteredHeaders));
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    protected ClusterBlockException checkBlock(PutSnapshotLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public Optional<String> reservedStateHandlerName() {
        return Optional.of("slm");
    }

    public Set<String> modifiedKeys(PutSnapshotLifecycleAction.Request request) {
        return Set.of(request.getLifecycleId());
    }

    static boolean isNoopUpdate(@Nullable SnapshotLifecyclePolicyMetadata existingPolicyMeta, SnapshotLifecyclePolicy newPolicy, Map<String, String> filteredHeaders) {
        if (existingPolicyMeta == null) {
            return false;
        }
        return newPolicy.equals((Object)existingPolicyMeta.getPolicy()) && filteredHeaders.equals(existingPolicyMeta.getHeaders());
    }

    public static class UpdateSnapshotPolicyTask
    extends AckedClusterStateUpdateTask {
        private final PutSnapshotLifecycleAction.Request request;
        private final Map<String, String> filteredHeaders;

        UpdateSnapshotPolicyTask(PutSnapshotLifecycleAction.Request request, ActionListener<AcknowledgedResponse> listener, Map<String, String> filteredHeaders) {
            super((AcknowledgedRequest)request, listener);
            this.request = request;
            this.filteredHeaders = filteredHeaders;
        }

        UpdateSnapshotPolicyTask(PutSnapshotLifecycleAction.Request request) {
            super((AcknowledgedRequest)request, null);
            this.request = request;
            this.filteredHeaders = Map.of();
        }

        public ClusterState execute(ClusterState currentState) {
            SnapshotLifecyclePolicyMetadata newLifecycle;
            ProjectMetadata project = currentState.metadata().getProject();
            SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)project.custom("snapshot_lifecycle", (Metadata.ProjectCustom)SnapshotLifecycleMetadata.EMPTY);
            OperationMode currentMode = LifecycleOperationMetadata.currentSLMMode((ClusterState)currentState);
            SnapshotLifecyclePolicyMetadata existingPolicyMetadata = (SnapshotLifecyclePolicyMetadata)snapMeta.getSnapshotConfigurations().get(this.request.getLifecycleId());
            if (TransportPutSnapshotLifecycleAction.isNoopUpdate(existingPolicyMetadata, this.request.getLifecycle(), this.filteredHeaders)) {
                return currentState;
            }
            long nextVersion = existingPolicyMetadata == null ? 1L : existingPolicyMetadata.getVersion() + 1L;
            HashMap<String, SnapshotLifecyclePolicyMetadata> snapLifecycles = new HashMap<String, SnapshotLifecyclePolicyMetadata>(snapMeta.getSnapshotConfigurations());
            SnapshotLifecyclePolicyMetadata oldPolicy = snapLifecycles.put((newLifecycle = SnapshotLifecyclePolicyMetadata.builder((SnapshotLifecyclePolicyMetadata)existingPolicyMetadata).setPolicy(this.request.getLifecycle()).setHeaders(this.filteredHeaders).setVersion(nextVersion).setModifiedDate(Instant.now().toEpochMilli()).build()).getId(), newLifecycle);
            if (oldPolicy == null) {
                logger.info("adding new snapshot lifecycle [{}]", (Object)newLifecycle.getId());
            } else {
                logger.info("updating existing snapshot lifecycle [{}]", (Object)newLifecycle.getId());
            }
            SnapshotLifecycleMetadata updatedMetadata = new SnapshotLifecycleMetadata(snapLifecycles, currentMode, snapMeta.getStats());
            return currentState.copyAndUpdateProject(project.id(), b -> b.putCustom("snapshot_lifecycle", (Metadata.ProjectCustom)updatedMetadata));
        }
    }
}

