/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public class Sample
extends UnaryPlan
implements TelemetryAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "Sample", Sample::new);
    private final Expression probability;

    public Sample(Source source, Expression probability, LogicalPlan child) {
        super(source, child);
        this.probability = probability;
    }

    private Sample(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (LogicalPlan)in.readNamedWriteable(LogicalPlan.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.source().writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.probability);
        out.writeNamedWriteable((NamedWriteable)this.child());
    }

    public String getWriteableName() {
        return Sample.ENTRY.name;
    }

    protected NodeInfo<Sample> info() {
        return NodeInfo.create((Node)this, Sample::new, (Object)this.probability, (Object)((Object)this.child()));
    }

    @Override
    public Sample replaceChild(LogicalPlan newChild) {
        return new Sample(this.source(), this.probability, newChild);
    }

    public Expression probability() {
        return this.probability;
    }

    @Override
    public boolean expressionsResolved() {
        return this.probability.resolved();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.probability, this.child()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Sample other = (Sample)obj;
        return Objects.equals(this.probability, other.probability) && Objects.equals((Object)this.child(), (Object)other.child());
    }
}

