/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan;

import java.util.Objects;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class QuerySetting {
    private final Source source;
    private final Alias field;

    public QuerySetting(Source source, Alias field) {
        this.source = source;
        this.field = field;
    }

    public Alias field() {
        return this.field;
    }

    public String name() {
        return this.field.name();
    }

    public Expression value() {
        return this.field.child();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuerySetting eval = (QuerySetting)o;
        return Objects.equals(this.field, eval.field);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.field);
    }

    public Source source() {
        return this.source;
    }

    public String toString() {
        return "SET " + this.name() + " = " + String.valueOf(this.value());
    }
}

