/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.List;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LogicalVerifier;
import org.elasticsearch.xpack.esql.optimizer.rules.PruneInlineJoinOnEmptyRightSide;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.BooleanFunctionEqualsElimination;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.BooleanSimplification;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.CombineBinaryComparisons;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.CombineDisjunctions;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.CombineEvals;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.CombineLimitTopN;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.CombineProjections;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ConstantFolding;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.DeduplicateAggs;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ExtractAggregateCommonFilter;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.FoldNull;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.HoistRemoteEnrichLimit;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.HoistRemoteEnrichTopN;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.LiteralsOnTheRight;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PartiallyFoldCase;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PropagateEmptyRelation;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PropagateEquals;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PropagateEvalFoldables;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PropagateInlineEvals;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PropagateNullable;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PropgateUnmappedFields;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PruneColumns;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PruneEmptyPlans;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PruneFilters;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PruneLiteralsInOrderBy;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PruneRedundantOrderBy;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PruneRedundantSortClauses;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PruneUnusedIndexMode;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PushDownAndCombineFilters;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PushDownAndCombineLimits;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PushDownAndCombineOrderBy;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PushDownAndCombineSample;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PushDownConjunctionsToKnnPrefilters;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PushDownEnrich;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PushDownEval;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PushDownInferencePlan;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PushDownJoinPastProject;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PushDownRegexExtract;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.PushLimitToKnn;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.RemoveStatsOverride;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceAggregateAggExpressionWithEval;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceAggregateNestedExpressionWithEval;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceAliasingEvalWithProject;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceLimitAndSortAsTopN;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceOrderByExpressionWithEval;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceRegexMatch;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceRowAsLocalRelation;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceStatsFilteredAggWithEval;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceStringCasingWithInsensitiveEquals;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.ReplaceTrivialTypeConversions;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.SetAsOptimized;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.SimplifyComparisonsArithmetics;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.SkipQueryOnEmptyMappings;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.SkipQueryOnLimitZero;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.SplitInWithFoldableValue;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.SubstituteFilteredExpression;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.SubstituteSurrogateAggregations;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.SubstituteSurrogateExpressions;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.SubstituteSurrogatePlans;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.TranslateTimeSeriesAggregate;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.local.PruneLeftJoinOnNullMatchingField;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.esql.rule.RuleExecutor;

public class LogicalPlanOptimizer
extends ParameterizedRuleExecutor<LogicalPlan, LogicalOptimizerContext> {
    private static final List<RuleExecutor.Batch<LogicalPlan>> RULES = List.of(LogicalPlanOptimizer.substitutions(), LogicalPlanOptimizer.operators(), new RuleExecutor.Batch("Skip Compute", new SkipQueryOnLimitZero()), LogicalPlanOptimizer.cleanup(), new RuleExecutor.Batch("Set as Optimized", RuleExecutor.Limiter.ONCE, new SetAsOptimized()));
    private final LogicalVerifier verifier = LogicalVerifier.INSTANCE;

    public LogicalPlanOptimizer(LogicalOptimizerContext optimizerContext) {
        super(optimizerContext);
    }

    public LogicalPlan optimize(LogicalPlan verified) {
        LogicalPlan optimized = this.execute(verified);
        Failures failures = this.verifier.verify(optimized, verified.output());
        if (failures.hasFailures()) {
            throw new VerificationException(failures);
        }
        optimized.setOptimized();
        return optimized;
    }

    @Override
    protected List<RuleExecutor.Batch<LogicalPlan>> batches() {
        return RULES;
    }

    protected static RuleExecutor.Batch<LogicalPlan> substitutions() {
        return new RuleExecutor.Batch<LogicalPlan>("Substitutions", RuleExecutor.Limiter.ONCE, new SubstituteSurrogatePlans(), new SubstituteFilteredExpression(), new RemoveStatsOverride(), new ReplaceAggregateNestedExpressionWithEval(), new ReplaceAggregateAggExpressionWithEval(), new SubstituteSurrogateAggregations(), new TranslateTimeSeriesAggregate(), new PruneUnusedIndexMode(), new SubstituteSurrogateAggregations(), new ReplaceAggregateNestedExpressionWithEval(), new PropagateInlineEvals(), new ReplaceRegexMatch(), new ReplaceTrivialTypeConversions(), new ReplaceAliasingEvalWithProject(), new SkipQueryOnEmptyMappings(), new SubstituteSurrogateExpressions(), new ReplaceOrderByExpressionWithEval());
    }

    protected static RuleExecutor.Batch<LogicalPlan> operators() {
        return new RuleExecutor.Batch<LogicalPlan>("Operator Optimization", new HoistRemoteEnrichLimit(), new CombineProjections(), new CombineEvals(), new PruneEmptyPlans(), new PropagateEmptyRelation(), new FoldNull(), new SplitInWithFoldableValue(), new PropagateEvalFoldables(), new ConstantFolding(), new DeduplicateAggs(), new PartiallyFoldCase(), new BooleanSimplification(), new LiteralsOnTheRight(), new PropagateEquals(), new PropagateNullable(), new BooleanFunctionEqualsElimination(), new CombineBinaryComparisons(), new CombineDisjunctions(), new SimplifyComparisonsArithmetics(DataType::areCompatible), new ReplaceStringCasingWithInsensitiveEquals(), new ReplaceStatsFilteredAggWithEval(), new ExtractAggregateCommonFilter(), new PruneFilters(), new PruneColumns(), new PruneLiteralsInOrderBy(), new PushDownAndCombineLimits(), new PushLimitToKnn(), new PushDownAndCombineFilters(), new PushDownConjunctionsToKnnPrefilters(), new PushDownAndCombineSample(), new PushDownInferencePlan(), new PushDownEval(), new PushDownRegexExtract(), new PushDownEnrich(), new PushDownJoinPastProject(), new PushDownAndCombineOrderBy(), new PruneRedundantOrderBy(), new PruneRedundantSortClauses(), new PruneLeftJoinOnNullMatchingField(), new PruneInlineJoinOnEmptyRightSide());
    }

    protected static RuleExecutor.Batch<LogicalPlan> cleanup() {
        return new RuleExecutor.Batch<LogicalPlan>("Clean Up", new ReplaceLimitAndSortAsTopN(), new HoistRemoteEnrichTopN(), new ReplaceRowAsLocalRelation(), new PropgateUnmappedFields(), new CombineLimitTopN());
    }
}

