/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.inference;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.xpack.esql.inference.ResolvedInference;

public class InferenceResolution {
    public static final InferenceResolution EMPTY = new Builder().build();
    private final Map<String, ResolvedInference> resolvedInferences;
    private final Map<String, String> errors;

    public static Builder builder() {
        return new Builder();
    }

    private InferenceResolution(Map<String, ResolvedInference> resolvedInferences, Map<String, String> errors) {
        this.resolvedInferences = Collections.unmodifiableMap(resolvedInferences);
        this.errors = Collections.unmodifiableMap(errors);
    }

    public ResolvedInference getResolvedInference(String inferenceId) {
        return this.resolvedInferences.get(inferenceId);
    }

    public Collection<ResolvedInference> resolvedInferences() {
        return this.resolvedInferences.values();
    }

    public boolean hasError() {
        return !this.errors.isEmpty();
    }

    public String getError(String inferenceId) {
        String error = this.errors.get(inferenceId);
        if (error != null) {
            return error;
        }
        return "unresolved inference [" + inferenceId + "]";
    }

    public static class Builder {
        private final Map<String, ResolvedInference> resolvedInferences = ConcurrentCollections.newConcurrentMap();
        private final Map<String, String> errors = ConcurrentCollections.newConcurrentMap();

        private Builder() {
        }

        public Builder withResolvedInference(ResolvedInference resolvedInference) {
            this.resolvedInferences.putIfAbsent(resolvedInference.inferenceId(), resolvedInference);
            return this;
        }

        public Builder withError(String inferenceId, String reason) {
            this.errors.putIfAbsent(inferenceId, reason);
            return this;
        }

        public InferenceResolution build() {
            return new InferenceResolution(this.resolvedInferences, this.errors);
        }
    }
}

