/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.vector;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.vector.VectorSimilarityFunction;

public class DotProduct
extends VectorSimilarityFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "DotProduct", DotProduct::new);
    static final VectorSimilarityFunction.SimilarityEvaluatorFunction SIMILARITY_FUNCTION = (arg_0, arg_1) -> ((org.apache.lucene.index.VectorSimilarityFunction)org.apache.lucene.index.VectorSimilarityFunction.DOT_PRODUCT).compare(arg_0, arg_1);

    @FunctionInfo(returnType={"double"}, preview=true, description="Calculates the dot product between two dense_vectors.", examples={@Example(file="vector-dot-product", tag="vector-dot-product")}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.DEVELOPMENT)})
    public DotProduct(Source source, @Param(name="left", type={"dense_vector"}, description="first dense_vector to calculate dot product similarity") Expression left, @Param(name="right", type={"dense_vector"}, description="second dense_vector to calculate dot product similarity") Expression right) {
        super(source, left, right);
    }

    private DotProduct(StreamInput in) throws IOException {
        super(in);
    }

    protected BinaryScalarFunction replaceChildren(Expression newLeft, Expression newRight) {
        return new DotProduct(this.source(), newLeft, newRight);
    }

    @Override
    protected VectorSimilarityFunction.SimilarityEvaluatorFunction getSimilarityFunction() {
        return SIMILARITY_FUNCTION;
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, DotProduct::new, (Object)this.left(), (Object)this.right());
    }

    public String getWriteableName() {
        return DotProduct.ENTRY.name;
    }
}

