/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ReplaceConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ReplaceEvaluator;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;

public class Replace
extends EsqlScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Replace", Replace::new);
    private static final TransportVersion ESQL_SERIALIZE_SOURCE_FUNCTIONS_WARNINGS = TransportVersion.fromName((String)"esql_serialize_source_functions_warnings");
    private final Expression str;
    private final Expression regex;
    private final Expression newStr;

    @FunctionInfo(returnType={"keyword"}, description="The function substitutes in the string `str` any match of the regular expression `regex`\nwith the replacement string `newStr`.", examples={@Example(file="string", tag="replaceString", description="This example replaces any occurrence of the word \"World\" with the word \"Universe\":"), @Example(file="string", tag="replaceRegex", description="This example removes all spaces:")})
    public Replace(Source source, @Param(name="string", type={"keyword", "text"}, description="String expression.") Expression str, @Param(name="regex", type={"keyword", "text"}, description="Regular expression.") Expression regex, @Param(name="newString", type={"keyword", "text"}, description="Replacement string.") Expression newStr) {
        super(source, Arrays.asList(str, regex, newStr));
        this.str = str;
        this.regex = regex;
        this.newStr = newStr;
    }

    private Replace(StreamInput in) throws IOException {
        this(in.getTransportVersion().supports(ESQL_SERIALIZE_SOURCE_FUNCTIONS_WARNINGS) ? Source.readFrom((StreamInput)((PlanStreamInput)in)) : Source.EMPTY, (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().supports(ESQL_SERIALIZE_SOURCE_FUNCTIONS_WARNINGS)) {
            this.source().writeTo(out);
        }
        out.writeNamedWriteable((NamedWriteable)this.str);
        out.writeNamedWriteable((NamedWriteable)this.regex);
        out.writeNamedWriteable((NamedWriteable)this.newStr);
    }

    public String getWriteableName() {
        return Replace.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.KEYWORD;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isString((Expression)this.str, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isString((Expression)this.regex, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isString((Expression)this.newStr, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD);
    }

    public boolean foldable() {
        return this.str.foldable() && this.regex.foldable() && this.newStr.foldable();
    }

    static BytesRef process(BytesRef str, Pattern regex, BytesRef newStr) {
        if (str == null || regex == null || newStr == null) {
            return null;
        }
        return Replace.safeReplace(str, regex, newStr);
    }

    static BytesRef process(BytesRef str, BytesRef regex, BytesRef newStr) {
        if (str == null) {
            return null;
        }
        if (regex == null || newStr == null) {
            return str;
        }
        return Replace.safeReplace(str, Pattern.compile(regex.utf8ToString()), newStr);
    }

    private static BytesRef safeReplace(BytesRef strBytesRef, Pattern regex, BytesRef newStrBytesRef) {
        String str = strBytesRef.utf8ToString();
        Matcher m = regex.matcher(str);
        if (!m.find()) {
            return strBytesRef;
        }
        String newStr = newStrBytesRef.utf8ToString();
        int constantReplacementLength = newStr.length();
        int groupsInReplacement = 0;
        for (int i = 0; i < newStr.length(); ++i) {
            if (newStr.charAt(i) != '$') continue;
            ++groupsInReplacement;
            constantReplacementLength -= 2;
            ++i;
        }
        StringBuilder result = new StringBuilder(str.length() + newStr.length() + 8);
        do {
            int matchSize = m.end() - m.start();
            int potentialReplacementSize = constantReplacementLength + groupsInReplacement * matchSize;
            int remainingStr = str.length() - m.end();
            if ((long)(result.length() + potentialReplacementSize + remainingStr) > MAX_BYTES_REF_RESULT_SIZE) {
                throw new IllegalArgumentException("Creating strings with more than [" + MAX_BYTES_REF_RESULT_SIZE + "] bytes is not supported");
            }
            m.appendReplacement(result, newStr);
        } while (m.find());
        m.appendTail(result);
        return new BytesRef((CharSequence)result.toString());
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Replace(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Replace::new, (Object)this.str, (Object)this.regex, (Object)this.newStr);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory strEval = toEvaluator.apply(this.str);
        EvalOperator.ExpressionEvaluator.Factory newStrEval = toEvaluator.apply(this.newStr);
        if (this.regex.foldable() && this.regex.dataType() == DataType.KEYWORD) {
            Pattern regexPattern = Pattern.compile(BytesRefs.toString((Object)this.regex.fold(toEvaluator.foldCtx())));
            return new ReplaceConstantEvaluator.Factory(this.source(), strEval, regexPattern, newStrEval);
        }
        EvalOperator.ExpressionEvaluator.Factory regexEval = toEvaluator.apply(this.regex);
        return new ReplaceEvaluator.Factory(this.source(), strEval, regexEval, newStrEval);
    }

    Expression str() {
        return this.str;
    }

    Expression regex() {
        return this.regex;
    }

    Expression newStr() {
        return this.newStr;
    }
}

