/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.EndsWith;

public final class EndsWithEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(EndsWithEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator str;
    private final EvalOperator.ExpressionEvaluator suffix;
    private final DriverContext driverContext;
    private Warnings warnings;

    public EndsWithEvaluator(Source source, EvalOperator.ExpressionEvaluator str, EvalOperator.ExpressionEvaluator suffix, DriverContext driverContext) {
        this.source = source;
        this.str = str;
        this.suffix = suffix;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock strBlock = (BytesRefBlock)this.str.eval(page);){
            BooleanBlock booleanBlock;
            block20: {
                BytesRefVector suffixVector;
                BytesRefVector strVector;
                BytesRefBlock suffixBlock;
                block18: {
                    BooleanBlock booleanBlock2;
                    block19: {
                        block16: {
                            BooleanBlock booleanBlock3;
                            block17: {
                                suffixBlock = (BytesRefBlock)this.suffix.eval(page);
                                try {
                                    strVector = strBlock.asVector();
                                    if (strVector != null) break block16;
                                    booleanBlock3 = this.eval(page.getPositionCount(), strBlock, suffixBlock);
                                    if (suffixBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (suffixBlock != null) {
                                        try {
                                            suffixBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                suffixBlock.close();
                            }
                            return booleanBlock3;
                        }
                        suffixVector = suffixBlock.asVector();
                        if (suffixVector != null) break block18;
                        booleanBlock2 = this.eval(page.getPositionCount(), strBlock, suffixBlock);
                        if (suffixBlock == null) break block19;
                        suffixBlock.close();
                    }
                    return booleanBlock2;
                }
                booleanBlock = this.eval(page.getPositionCount(), strVector, suffixVector).asBlock();
                if (suffixBlock == null) break block20;
                suffixBlock.close();
            }
            return booleanBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.str.baseRamBytesUsed();
        return baseRamBytesUsed += this.suffix.baseRamBytesUsed();
    }

    public BooleanBlock eval(int positionCount, BytesRefBlock strBlock, BytesRefBlock suffixBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            BytesRef suffixScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (strBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (strBlock.getValueCount(p) != 1) {
                    if (strBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (suffixBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (suffixBlock.getValueCount(p) != 1) {
                    if (suffixBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                BytesRef str = strBlock.getBytesRef(strBlock.getFirstValueIndex(p), strScratch);
                BytesRef suffix = suffixBlock.getBytesRef(suffixBlock.getFirstValueIndex(p), suffixScratch);
                result.appendBoolean(EndsWith.process(str, suffix));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, BytesRefVector strVector, BytesRefVector suffixVector) {
        try (BooleanVector.FixedBuilder result = this.driverContext.blockFactory().newBooleanVectorFixedBuilder(positionCount);){
            BytesRef strScratch = new BytesRef();
            BytesRef suffixScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                BytesRef str = strVector.getBytesRef(p, strScratch);
                BytesRef suffix = suffixVector.getBytesRef(p, suffixScratch);
                result.appendBoolean(p, EndsWith.process(str, suffix));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "EndsWithEvaluator[str=" + String.valueOf(this.str) + ", suffix=" + String.valueOf(this.suffix) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.str, this.suffix});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory str;
        private final EvalOperator.ExpressionEvaluator.Factory suffix;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory str, EvalOperator.ExpressionEvaluator.Factory suffix) {
            this.source = source;
            this.str = str;
            this.suffix = suffix;
        }

        public EndsWithEvaluator get(DriverContext context) {
            return new EndsWithEvaluator(this.source, this.str.get(context), this.suffix.get(context), context);
        }

        public String toString() {
            return "EndsWithEvaluator[str=" + String.valueOf(this.str) + ", suffix=" + String.valueOf(this.suffix) + "]";
        }
    }
}

