/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SloppyMath;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.BinarySpatialFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesUtils;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistanceCartesianPointDocValuesAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistanceCartesianPointDocValuesAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistanceCartesianSourceAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistanceCartesianSourceAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistanceGeoPointDocValuesAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistanceGeoPointDocValuesAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistanceGeoSourceAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StDistanceGeoSourceAndSourceEvaluator;

public class StDistance
extends BinarySpatialFunction
implements EvaluatorMapper {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "StDistance", StDistance::new);
    public static final DistanceCalculator GEO = new GeoDistanceCalculator();
    public static final DistanceCalculator CARTESIAN = new CartesianDistanceCalculator();

    @FunctionInfo(returnType={"double"}, description="Computes the distance between two points.\nFor cartesian geometries, this is the pythagorean distance in the same units as the original coordinates.\nFor geographic geometries, this is the circular distance along the great circle in meters.", examples={@Example(file="spatial", tag="st_distance-airports")})
    public StDistance(Source source, @Param(name="geomA", type={"geo_point", "cartesian_point"}, description="Expression of type `geo_point` or `cartesian_point`.\nIf `null`, the function returns `null`.") Expression left, @Param(name="geomB", type={"geo_point", "cartesian_point"}, description="Expression of type `geo_point` or `cartesian_point`.\nIf `null`, the function returns `null`.\nThe second parameter must also have the same coordinate system as the first.\nThis means it is not possible to combine `geo_point` and `cartesian_point` parameters.") Expression right) {
        super(source, left, right, false, false, true, false);
    }

    protected StDistance(Source source, Expression left, Expression right, boolean leftDocValues, boolean rightDocValues) {
        super(source, left, right, leftDocValues, rightDocValues, true, false);
    }

    private StDistance(StreamInput in) throws IOException {
        super(in, false, false, true, false);
    }

    @Override
    public StDistance withDocValues(boolean foundLeft, boolean foundRight) {
        boolean leftDV = this.leftDocValues || foundLeft;
        boolean rightDV = this.rightDocValues || foundRight;
        return new StDistance(this.source(), this.left(), this.right(), leftDV, rightDV);
    }

    public String getWriteableName() {
        return StDistance.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.DOUBLE;
    }

    protected StDistance replaceChildren(Expression newLeft, Expression newRight) {
        return new StDistance(this.source(), newLeft, newRight, this.leftDocValues, this.rightDocValues);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, StDistance::new, (Object)this.left(), (Object)this.right());
    }

    @Override
    protected Object fold(Geometry leftGeom, Geometry rightGeom) {
        return this.crsType() == BinarySpatialFunction.SpatialCrsType.GEO ? GEO.distance(leftGeom, rightGeom) : CARTESIAN.distance(leftGeom, rightGeom);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        if (this.right().foldable()) {
            return this.toEvaluator(toEvaluator, this.left(), SpatialRelatesUtils.makeGeometryFromLiteral(toEvaluator.foldCtx(), this.right()), this.leftDocValues);
        }
        if (this.left().foldable()) {
            return this.toEvaluator(toEvaluator, this.right(), SpatialRelatesUtils.makeGeometryFromLiteral(toEvaluator.foldCtx(), this.left()), this.rightDocValues);
        }
        EvalOperator.ExpressionEvaluator.Factory leftE = toEvaluator.apply(this.left());
        EvalOperator.ExpressionEvaluator.Factory rightE = toEvaluator.apply(this.right());
        if (this.crsType() == BinarySpatialFunction.SpatialCrsType.GEO) {
            if (this.leftDocValues) {
                return new StDistanceGeoPointDocValuesAndSourceEvaluator.Factory(this.source(), leftE, rightE);
            }
            if (this.rightDocValues) {
                return new StDistanceGeoPointDocValuesAndSourceEvaluator.Factory(this.source(), rightE, leftE);
            }
            return new StDistanceGeoSourceAndSourceEvaluator.Factory(this.source(), leftE, rightE);
        }
        if (this.crsType() == BinarySpatialFunction.SpatialCrsType.CARTESIAN) {
            if (this.leftDocValues) {
                return new StDistanceCartesianPointDocValuesAndSourceEvaluator.Factory(this.source(), leftE, rightE);
            }
            if (this.rightDocValues) {
                return new StDistanceCartesianPointDocValuesAndSourceEvaluator.Factory(this.source(), rightE, leftE);
            }
            return new StDistanceCartesianSourceAndSourceEvaluator.Factory(this.source(), leftE, rightE);
        }
        throw EsqlIllegalArgumentException.illegalDataType(this.crsType().name());
    }

    private EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator, Expression field, Geometry geometry, boolean docValues) {
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            return this.toEvaluator(toEvaluator, field, point, docValues);
        }
        throw new IllegalArgumentException("Unsupported geometry type for ST_DISTANCE: " + geometry.type().name());
    }

    private EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator, Expression field, Point point, boolean docValues) {
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(field);
        if (this.crsType() == BinarySpatialFunction.SpatialCrsType.GEO) {
            if (docValues) {
                return new StDistanceGeoPointDocValuesAndConstantEvaluator.Factory(this.source(), fieldEvaluator, point);
            }
            return new StDistanceGeoSourceAndConstantEvaluator.Factory(this.source(), fieldEvaluator, point);
        }
        if (this.crsType() == BinarySpatialFunction.SpatialCrsType.CARTESIAN) {
            if (docValues) {
                return new StDistanceCartesianPointDocValuesAndConstantEvaluator.Factory(this.source(), fieldEvaluator, point);
            }
            return new StDistanceCartesianSourceAndConstantEvaluator.Factory(this.source(), fieldEvaluator, point);
        }
        throw EsqlIllegalArgumentException.illegalDataType(this.crsType().name());
    }

    static void processGeoSourceAndConstant(DoubleBlock.Builder results, int p, BytesRefBlock left, Point right) {
        GEO.distanceSourceAndConstant(results, p, left, right);
    }

    static void processGeoSourceAndSource(DoubleBlock.Builder results, int p, BytesRefBlock left, BytesRefBlock right) {
        GEO.distanceSourceAndSource(results, p, left, right);
    }

    static void processGeoPointDocValuesAndConstant(DoubleBlock.Builder results, int p, LongBlock left, Point right) {
        GEO.distancePointDocValuesAndConstant(results, p, left, right);
    }

    static void processGeoPointDocValuesAndSource(DoubleBlock.Builder results, int p, LongBlock left, BytesRefBlock right) {
        GEO.distancePointDocValuesAndSource(results, p, left, right);
    }

    static void processCartesianSourceAndConstant(DoubleBlock.Builder results, int p, BytesRefBlock left, Point right) {
        CARTESIAN.distanceSourceAndConstant(results, p, left, right);
    }

    static void processCartesianSourceAndSource(DoubleBlock.Builder results, int p, BytesRefBlock left, BytesRefBlock right) {
        CARTESIAN.distanceSourceAndSource(results, p, left, right);
    }

    static void processCartesianPointDocValuesAndConstant(DoubleBlock.Builder results, int p, LongBlock left, Point right) {
        CARTESIAN.distancePointDocValuesAndConstant(results, p, left, right);
    }

    static void processCartesianPointDocValuesAndSource(DoubleBlock.Builder results, int p, LongBlock left, BytesRefBlock right) {
        CARTESIAN.distancePointDocValuesAndSource(results, p, left, right);
    }

    public static abstract class DistanceCalculator
    extends BinarySpatialFunction.BinarySpatialComparator<Double> {
        protected DistanceCalculator(SpatialCoordinateTypes spatialCoordinateType, CoordinateEncoder encoder) {
            super(spatialCoordinateType, encoder);
        }

        @Override
        protected Double compare(BytesRef left, BytesRef right) throws IOException {
            return this.distance(left, right);
        }

        protected abstract double distance(Point var1, Point var2);

        protected double distance(Geometry left, Geometry right) {
            return this.distance((Point)left, (Point)right);
        }

        public double distance(BytesRef left, BytesRef right) {
            return this.distance(this.fromBytesRef(left), this.fromBytesRef(right));
        }

        public void distanceSourceAndConstant(DoubleBlock.Builder results, int position, BytesRefBlock left, Point right) {
            int valueCount = left.getValueCount(position);
            if (valueCount < 1) {
                results.appendNull();
            } else {
                BytesRef scratch = new BytesRef();
                int firstValueIndex = left.getFirstValueIndex(position);
                double distance = Double.MAX_VALUE;
                if (valueCount == 1) {
                    distance = this.distance(this.fromBytesRef(left.getBytesRef(firstValueIndex, scratch)), (Geometry)right);
                } else {
                    for (int i = 0; i < valueCount; ++i) {
                        double value = this.distance(this.fromBytesRef(left.getBytesRef(firstValueIndex + i, scratch)), (Geometry)right);
                        if (!(value < distance)) continue;
                        distance = value;
                    }
                }
                results.appendDouble(distance);
            }
        }

        public void distanceSourceAndSource(DoubleBlock.Builder results, int position, BytesRefBlock left, BytesRefBlock right) {
            int leftCount = left.getValueCount(position);
            int rightCount = right.getValueCount(position);
            if (leftCount < 1 || rightCount < 1) {
                results.appendNull();
            } else {
                BytesRef scratchLeft = new BytesRef();
                BytesRef scratchRight = new BytesRef();
                int leftFirstValueIndex = left.getFirstValueIndex(position);
                int rightFirstValueIndex = right.getFirstValueIndex(position);
                double distance = Double.MAX_VALUE;
                if (leftCount == 1 && rightCount == 1) {
                    distance = this.distance(this.fromBytesRef(left.getBytesRef(leftFirstValueIndex, scratchLeft)), this.fromBytesRef(right.getBytesRef(rightFirstValueIndex, scratchRight)));
                } else {
                    for (int i = 0; i < leftCount; ++i) {
                        for (int j = 0; j < rightCount; ++j) {
                            double value = this.distance(this.fromBytesRef(left.getBytesRef(leftFirstValueIndex + i, scratchLeft)), this.fromBytesRef(right.getBytesRef(rightFirstValueIndex + j, scratchRight)));
                            if (!(value < distance)) continue;
                            distance = value;
                        }
                    }
                }
                results.appendDouble(distance);
            }
        }

        public void distancePointDocValuesAndConstant(DoubleBlock.Builder results, int position, LongBlock left, Point right) {
            int valueCount = left.getValueCount(position);
            if (valueCount < 1) {
                results.appendNull();
            } else {
                int firstValueIndex = left.getFirstValueIndex(position);
                double distance = Double.MAX_VALUE;
                if (valueCount == 1) {
                    distance = this.distance(this.spatialCoordinateType.longAsPoint(left.getLong(firstValueIndex)), right);
                } else {
                    for (int i = 0; i < valueCount; ++i) {
                        double value = this.distance(this.spatialCoordinateType.longAsPoint(left.getLong(firstValueIndex + i)), right);
                        if (!(value < distance)) continue;
                        distance = value;
                    }
                }
                results.appendDouble(distance);
            }
        }

        public void distancePointDocValuesAndSource(DoubleBlock.Builder results, int position, LongBlock left, BytesRefBlock right) {
            int leftCount = left.getValueCount(position);
            int rightCount = right.getValueCount(position);
            if (leftCount < 1 || rightCount < 1) {
                results.appendNull();
            } else {
                BytesRef scratchRight = new BytesRef();
                int leftFirstValueIndex = left.getFirstValueIndex(position);
                int rightFirstValueIndex = right.getFirstValueIndex(position);
                double distance = Double.MAX_VALUE;
                if (leftCount == 1 && rightCount == 1) {
                    distance = this.distance((Geometry)this.spatialCoordinateType.longAsPoint(left.getLong(leftFirstValueIndex)), this.fromBytesRef(right.getBytesRef(rightFirstValueIndex, scratchRight)));
                }
                for (int i = 0; i < leftCount; ++i) {
                    for (int j = 0; j < rightCount; ++j) {
                        double value = this.distance((Geometry)this.spatialCoordinateType.longAsPoint(left.getLong(leftFirstValueIndex + i)), this.fromBytesRef(right.getBytesRef(rightFirstValueIndex + j, scratchRight)));
                        if (!(value < distance)) continue;
                        distance = value;
                    }
                }
                results.appendDouble(distance);
            }
        }
    }

    protected static class GeoDistanceCalculator
    extends DistanceCalculator {
        protected GeoDistanceCalculator() {
            super(SpatialCoordinateTypes.GEO, CoordinateEncoder.GEO);
        }

        @Override
        protected double distance(Point left, Point right) {
            return SloppyMath.haversinMeters((double)GeoUtils.quantizeLat((double)left.getY()), (double)GeoUtils.quantizeLon((double)left.getX()), (double)GeoUtils.quantizeLat((double)right.getY()), (double)GeoUtils.quantizeLon((double)right.getX()));
        }
    }

    protected static class CartesianDistanceCalculator
    extends DistanceCalculator {
        protected CartesianDistanceCalculator() {
            super(SpatialCoordinateTypes.CARTESIAN, CoordinateEncoder.CARTESIAN);
        }

        @Override
        protected double distance(Point left, Point right) {
            double diffX = (double)((float)left.getX()) - (double)((float)right.getX());
            double diffY = (double)((float)left.getY()) - (double)((float)right.getY());
            return Math.sqrt(diffX * diffX + diffY * diffY);
        }
    }
}

