/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvZip;

public final class MvZipEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MvZipEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator leftField;
    private final EvalOperator.ExpressionEvaluator rightField;
    private final EvalOperator.ExpressionEvaluator delim;
    private final DriverContext driverContext;
    private Warnings warnings;

    public MvZipEvaluator(Source source, EvalOperator.ExpressionEvaluator leftField, EvalOperator.ExpressionEvaluator rightField, EvalOperator.ExpressionEvaluator delim, DriverContext driverContext) {
        this.source = source;
        this.leftField = leftField;
        this.rightField = rightField;
        this.delim = delim;
        this.driverContext = driverContext;
    }

    /*
     * Exception decompiling
     */
    public Block eval(Page page) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.leftField.baseRamBytesUsed();
        baseRamBytesUsed += this.rightField.baseRamBytesUsed();
        return baseRamBytesUsed += this.delim.baseRamBytesUsed();
    }

    public BytesRefBlock eval(int positionCount, BytesRefBlock leftFieldBlock, BytesRefBlock rightFieldBlock, BytesRefBlock delimBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef delimScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!leftFieldBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (!rightFieldBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (delimBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (delimBlock.getValueCount(p) != 1) {
                    if (delimBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                BytesRef delim = delimBlock.getBytesRef(delimBlock.getFirstValueIndex(p), delimScratch);
                MvZip.process(result, p, leftFieldBlock, rightFieldBlock, delim);
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public String toString() {
        return "MvZipEvaluator[leftField=" + String.valueOf(this.leftField) + ", rightField=" + String.valueOf(this.rightField) + ", delim=" + String.valueOf(this.delim) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.leftField, this.rightField, this.delim});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory leftField;
        private final EvalOperator.ExpressionEvaluator.Factory rightField;
        private final EvalOperator.ExpressionEvaluator.Factory delim;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory leftField, EvalOperator.ExpressionEvaluator.Factory rightField, EvalOperator.ExpressionEvaluator.Factory delim) {
            this.source = source;
            this.leftField = leftField;
            this.rightField = rightField;
            this.delim = delim;
        }

        public MvZipEvaluator get(DriverContext context) {
            return new MvZipEvaluator(this.source, this.leftField.get(context), this.rightField.get(context), this.delim.get(context), context);
        }

        public String toString() {
            return "MvZipEvaluator[leftField=" + String.valueOf(this.leftField) + ", rightField=" + String.valueOf(this.rightField) + ", delim=" + String.valueOf(this.delim) + "]";
        }
    }
}

