/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CopySign;

public final class CopySignIntegerEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(CopySignIntegerEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator magnitude;
    private final EvalOperator.ExpressionEvaluator sign;
    private final DriverContext driverContext;
    private Warnings warnings;

    public CopySignIntegerEvaluator(Source source, EvalOperator.ExpressionEvaluator magnitude, EvalOperator.ExpressionEvaluator sign, DriverContext driverContext) {
        this.source = source;
        this.magnitude = magnitude;
        this.sign = sign;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (IntBlock magnitudeBlock = (IntBlock)this.magnitude.eval(page);){
            IntBlock intBlock;
            block20: {
                DoubleVector signVector;
                IntVector magnitudeVector;
                DoubleBlock signBlock;
                block18: {
                    IntBlock intBlock2;
                    block19: {
                        block16: {
                            IntBlock intBlock3;
                            block17: {
                                signBlock = (DoubleBlock)this.sign.eval(page);
                                try {
                                    magnitudeVector = magnitudeBlock.asVector();
                                    if (magnitudeVector != null) break block16;
                                    intBlock3 = this.eval(page.getPositionCount(), magnitudeBlock, signBlock);
                                    if (signBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (signBlock != null) {
                                        try {
                                            signBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                signBlock.close();
                            }
                            return intBlock3;
                        }
                        signVector = signBlock.asVector();
                        if (signVector != null) break block18;
                        intBlock2 = this.eval(page.getPositionCount(), magnitudeBlock, signBlock);
                        if (signBlock == null) break block19;
                        signBlock.close();
                    }
                    return intBlock2;
                }
                intBlock = this.eval(page.getPositionCount(), magnitudeVector, signVector).asBlock();
                if (signBlock == null) break block20;
                signBlock.close();
            }
            return intBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.magnitude.baseRamBytesUsed();
        return baseRamBytesUsed += this.sign.baseRamBytesUsed();
    }

    public IntBlock eval(int positionCount, IntBlock magnitudeBlock, DoubleBlock signBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (magnitudeBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (magnitudeBlock.getValueCount(p) != 1) {
                    if (magnitudeBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                if (signBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (signBlock.getValueCount(p) != 1) {
                    if (signBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                int magnitude = magnitudeBlock.getInt(magnitudeBlock.getFirstValueIndex(p));
                double sign = signBlock.getDouble(signBlock.getFirstValueIndex(p));
                result.appendInt(CopySign.processInteger(magnitude, sign));
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntVector eval(int positionCount, IntVector magnitudeVector, DoubleVector signVector) {
        try (IntVector.FixedBuilder result = this.driverContext.blockFactory().newIntVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int magnitude = magnitudeVector.getInt(p);
                double sign = signVector.getDouble(p);
                result.appendInt(p, CopySign.processInteger(magnitude, sign));
            }
            IntVector intVector = result.build();
            return intVector;
        }
    }

    public String toString() {
        return "CopySignIntegerEvaluator[magnitude=" + String.valueOf(this.magnitude) + ", sign=" + String.valueOf(this.sign) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.magnitude, this.sign});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory magnitude;
        private final EvalOperator.ExpressionEvaluator.Factory sign;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory magnitude, EvalOperator.ExpressionEvaluator.Factory sign) {
            this.source = source;
            this.magnitude = magnitude;
            this.sign = sign;
        }

        public CopySignIntegerEvaluator get(DriverContext context) {
            return new CopySignIntegerEvaluator(this.source, this.magnitude.get(context), this.sign.get(context), context);
        }

        public String toString() {
            return "CopySignIntegerEvaluator[magnitude=" + String.valueOf(this.magnitude) + ", sign=" + String.valueOf(this.sign) + "]";
        }
    }
}

