/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.Step;

public abstract class IndexLifecycleClusterStateUpdateTask
implements ClusterStateTaskListener {
    private final ListenableFuture<Void> listener = new ListenableFuture();
    protected final ProjectId projectId;
    protected final Index index;
    protected final Step.StepKey currentStepKey;
    private boolean executed;

    protected IndexLifecycleClusterStateUpdateTask(ProjectId projectId, Index index, Step.StepKey currentStepKey) {
        this.projectId = projectId;
        this.index = index;
        this.currentStepKey = currentStepKey;
    }

    final Index getIndex() {
        return this.index;
    }

    final Step.StepKey getCurrentStepKey() {
        return this.currentStepKey;
    }

    public final ClusterState execute(ProjectState currentState) throws Exception {
        assert (!this.executed);
        ClusterState updatedState = this.doExecute(currentState);
        if (currentState.cluster() != updatedState) {
            this.executed = true;
        }
        return updatedState;
    }

    protected abstract ClusterState doExecute(ProjectState var1) throws Exception;

    public final void clusterStateProcessed(ProjectState newState) {
        this.listener.onResponse(null);
        if (this.executed) {
            this.onClusterStateProcessed(newState);
        }
    }

    public final void onFailure(Exception e) {
        this.listener.onFailure(e);
        this.handleFailure(e);
    }

    public final void addListener(ActionListener<Void> actionListener) {
        this.listener.addListener(actionListener);
    }

    protected void onClusterStateProcessed(ProjectState newState) {
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    protected abstract void handleFailure(Exception var1);
}

