/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.cache.shared;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.searchablesnapshots.action.cache.FrozenCacheInfoAction;
import org.elasticsearch.xpack.searchablesnapshots.action.cache.FrozenCacheInfoResponse;

public class FrozenCacheInfoService {
    private static final Logger logger = LogManager.getLogger(FrozenCacheInfoService.class);
    private final Object mutex = new Object();
    private final Map<DiscoveryNode, NodeStateHolder> nodeStates = new HashMap<DiscoveryNode, NodeStateHolder>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNodes(Client client, Set<DiscoveryNode> nodes, RerouteService rerouteService) {
        ArrayList<AsyncNodeFetch> newFetches;
        Object object = this.mutex;
        synchronized (object) {
            this.nodeStates.keySet().removeIf(n -> !nodes.contains(n));
            nodes.removeAll(this.nodeStates.keySet());
            newFetches = new ArrayList<AsyncNodeFetch>(nodes.size());
            for (DiscoveryNode newNode : nodes) {
                NodeStateHolder nodeStateHolder = new NodeStateHolder();
                NodeStateHolder prevState = this.nodeStates.put(newNode, nodeStateHolder);
                assert (prevState == null);
                logger.trace("fetching frozen cache state for {}", (Object)newNode);
                newFetches.add(new AsyncNodeFetch(client, rerouteService, newNode, nodeStateHolder));
            }
        }
        newFetches.forEach(Runnable::run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState getNodeState(DiscoveryNode discoveryNode) {
        NodeStateHolder nodeStateHolder;
        Object object = this.mutex;
        synchronized (object) {
            nodeStateHolder = this.nodeStates.get(discoveryNode);
        }
        return nodeStateHolder == null ? NodeState.UNKNOWN : nodeStateHolder.nodeState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            this.nodeStates.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFetching() {
        Object object = this.mutex;
        synchronized (object) {
            return this.nodeStates.values().stream().anyMatch(nodeStateHolder -> nodeStateHolder.nodeState == NodeState.FETCHING);
        }
    }

    private static class NodeStateHolder {
        volatile NodeState nodeState = NodeState.FETCHING;

        private NodeStateHolder() {
        }
    }

    private class AsyncNodeFetch
    extends AbstractRunnable {
        private final Client client;
        private final RerouteService rerouteService;
        private final DiscoveryNode discoveryNode;
        private final NodeStateHolder nodeStateHolder;

        AsyncNodeFetch(Client client, RerouteService rerouteService, DiscoveryNode discoveryNode, NodeStateHolder nodeStateHolder) {
            this.client = client;
            this.rerouteService = rerouteService;
            this.discoveryNode = discoveryNode;
            this.nodeStateHolder = nodeStateHolder;
        }

        protected void doRun() {
            this.client.execute((ActionType)FrozenCacheInfoAction.INSTANCE, (ActionRequest)new FrozenCacheInfoAction.Request(this.discoveryNode), (ActionListener)new ActionListener<FrozenCacheInfoResponse>(){

                public void onResponse(FrozenCacheInfoResponse response) {
                    AsyncNodeFetch.this.updateEntry(response.hasFrozenCache() ? NodeState.HAS_CACHE : NodeState.NO_CACHE);
                    AsyncNodeFetch.this.rerouteService.reroute("frozen cache state retrieved", Priority.LOW, ActionListener.noop());
                }

                public void onFailure(Exception e) {
                    AsyncNodeFetch.this.retryOrRecordFailure(e);
                }
            });
        }

        public void onFailure(Exception e) {
            logger.debug(() -> "--> failed fetching frozen cache info from [" + String.valueOf(this.discoveryNode) + "]", (Throwable)e);
            this.updateEntry(NodeState.FAILED);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void retryOrRecordFailure(Exception e) {
            boolean shouldRetry;
            Object object = FrozenCacheInfoService.this.mutex;
            synchronized (object) {
                shouldRetry = FrozenCacheInfoService.this.nodeStates.get(this.discoveryNode) == this.nodeStateHolder;
            }
            logger.debug(() -> Strings.format((String)"failed to retrieve node settings from node %s, shouldRetry=%s", (Object[])new Object[]{this.discoveryNode, shouldRetry}), (Throwable)e);
            if (shouldRetry) {
                this.client.threadPool().scheduleUnlessShuttingDown(TimeValue.timeValueSeconds((long)1L), (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE, (Runnable)((Object)this));
            } else {
                this.updateEntry(NodeState.FAILED);
            }
        }

        private void updateEntry(NodeState nodeState) {
            assert (this.nodeStateHolder.nodeState == NodeState.FETCHING) : String.valueOf(this.discoveryNode) + " already set to " + String.valueOf((Object)this.nodeStateHolder.nodeState);
            assert (nodeState != NodeState.FETCHING && nodeState != NodeState.UNKNOWN) : "cannot set " + String.valueOf(this.discoveryNode) + " to " + String.valueOf((Object)nodeState);
            logger.trace("updating entry for {} to {}", (Object)this.discoveryNode, (Object)nodeState);
            this.nodeStateHolder.nodeState = nodeState;
        }
    }

    public static enum NodeState {
        UNKNOWN,
        FETCHING,
        HAS_CACHE,
        NO_CACHE,
        FAILED;

    }
}

