/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import java.util.function.LongBinaryOperator;
import org.elasticsearch.exponentialhistogram.BucketIterator;
import org.elasticsearch.exponentialhistogram.ScaleAdjustingBucketIterator;

final class MergingBucketIterator
implements BucketIterator {
    private final BucketIterator itA;
    private final BucketIterator itB;
    private boolean endReached;
    private long currentIndex;
    private long currentCount;
    private final LongBinaryOperator countMergeOperator;

    MergingBucketIterator(BucketIterator itA, BucketIterator itB, int targetScale) {
        this(itA, itB, targetScale, Long::sum);
    }

    MergingBucketIterator(BucketIterator itA, BucketIterator itB, int targetScale, LongBinaryOperator countMergeOperator) {
        this.itA = new ScaleAdjustingBucketIterator(itA, targetScale);
        this.itB = new ScaleAdjustingBucketIterator(itB, targetScale);
        this.countMergeOperator = countMergeOperator;
        this.endReached = false;
        this.advance();
    }

    @Override
    public void advance() {
        boolean hasNextA = this.itA.hasNext();
        boolean hasNextB = this.itB.hasNext();
        boolean bl = this.endReached = !hasNextA && !hasNextB;
        if (this.endReached) {
            return;
        }
        long idxA = 0L;
        long idxB = 0L;
        if (hasNextA) {
            idxA = this.itA.peekIndex();
        }
        if (hasNextB) {
            idxB = this.itB.peekIndex();
        }
        boolean advanceA = hasNextA && (!hasNextB || idxA <= idxB);
        boolean advanceB = hasNextB && (!hasNextA || idxB <= idxA);
        long countA = 0L;
        long countB = 0L;
        if (advanceA) {
            this.currentIndex = idxA;
            countA = this.itA.peekCount();
            this.itA.advance();
        }
        if (advanceB) {
            this.currentIndex = idxB;
            countB = this.itB.peekCount();
            this.itB.advance();
        }
        this.currentCount = this.countMergeOperator.applyAsLong(countA, countB);
    }

    @Override
    public boolean hasNext() {
        return !this.endReached;
    }

    @Override
    public long peekCount() {
        this.assertEndNotReached();
        return this.currentCount;
    }

    @Override
    public long peekIndex() {
        this.assertEndNotReached();
        return this.currentIndex;
    }

    @Override
    public int scale() {
        return this.itA.scale();
    }

    private void assertEndNotReached() {
        if (this.endReached) {
            throw new IllegalStateException("Iterator has no more buckets");
        }
    }
}

